/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeNonUniqueSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeUniqueSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NumberLayout;
import org.neo4j.kernel.impl.index.schema.NumberLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.NumberLayoutUnique;
import org.neo4j.kernel.impl.index.schema.NumberSchemaIndexAccessor;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.values.storable.ValueGroup;

public class NumberSchemaIndexProvider
extends SchemaIndexProvider {
    public static final String KEY = "native";
    public static final SchemaIndexProvider.Descriptor NATIVE_PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("native", "1.0");
    static final IndexCapability CAPABILITY = new NativeIndexCapability();
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final SchemaIndexProvider.Monitor monitor;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final boolean readOnly;

    public NumberSchemaIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, SchemaIndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(NATIVE_PROVIDER_DESCRIPTOR, 0, directoryStructure);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
    }

    @Override
    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        File storeFile = this.nativeIndexFileFromIndexId(indexId);
        switch (descriptor.type()) {
            case GENERAL: {
                return new NativeNonUniqueSchemaIndexPopulator(this.pageCache, this.fs, storeFile, new NumberLayoutNonUnique(), samplingConfig, this.monitor, descriptor, indexId);
            }
            case UNIQUE: {
                return new NativeUniqueSchemaIndexPopulator(this.pageCache, this.fs, storeFile, new NumberLayoutUnique(), this.monitor, descriptor, indexId);
            }
        }
        throw new UnsupportedOperationException("Can not create index populator of type " + (Object)((Object)descriptor.type()));
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        NumberLayout layout;
        File storeFile = this.nativeIndexFileFromIndexId(indexId);
        switch (descriptor.type()) {
            case GENERAL: {
                layout = new NumberLayoutNonUnique();
                break;
            }
            case UNIQUE: {
                layout = new NumberLayoutUnique();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can not create index accessor of type " + (Object)((Object)descriptor.type()));
            }
        }
        return new NumberSchemaIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, indexId, samplingConfig);
    }

    @Override
    public String getPopulationFailure(long indexId) throws IllegalStateException {
        try {
            String failureMessage = this.readPopulationFailure(indexId);
            if (failureMessage == null) {
                throw new IllegalStateException("Index " + indexId + " isn't failed");
            }
            return failureMessage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readPopulationFailure(long indexId) throws IOException {
        NativeSchemaIndexHeaderReader headerReader = new NativeSchemaIndexHeaderReader();
        GBPTree.readHeader((PageCache)this.pageCache, (File)this.nativeIndexFileFromIndexId(indexId), (Layout)new ReadOnlyMetaNumberLayout(), (Header.Reader)headerReader);
        return headerReader.failureMessage;
    }

    @Override
    public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
        try {
            NativeSchemaIndexHeaderReader headerReader = new NativeSchemaIndexHeaderReader();
            GBPTree.readHeader((PageCache)this.pageCache, (File)this.nativeIndexFileFromIndexId(indexId), (Layout)new ReadOnlyMetaNumberLayout(), (Header.Reader)headerReader);
            switch (headerReader.state) {
                case 0: {
                    return InternalIndexState.FAILED;
                }
                case 1: {
                    return InternalIndexState.ONLINE;
                }
                case 2: {
                    return InternalIndexState.POPULATING;
                }
            }
            throw new IllegalStateException("Unexpected initial state byte value " + headerReader.state);
        }
        catch (IOException e) {
            this.monitor.failedToOpenIndex(indexId, descriptor, "Requesting re-population.", e);
            return InternalIndexState.POPULATING;
        }
    }

    @Override
    public IndexCapability getCapability(IndexDescriptor indexDescriptor) {
        return CAPABILITY;
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private File nativeIndexFileFromIndexId(long indexId) {
        return new File(this.directoryStructure().directoryForIndex(indexId), NumberSchemaIndexProvider.indexFileName(indexId));
    }

    private static String indexFileName(long indexId) {
        return "index-" + indexId;
    }

    private static class NativeIndexCapability
    implements IndexCapability {
        private static final IndexOrder[] SUPPORTED_ORDER = new IndexOrder[]{IndexOrder.ASCENDING};
        private static final IndexOrder[] EMPTY_ORDER = new IndexOrder[0];

        private NativeIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueGroup ... valueGroups) {
            if (this.support(valueGroups)) {
                return SUPPORTED_ORDER;
            }
            return EMPTY_ORDER;
        }

        public IndexValueCapability valueCapability(ValueGroup ... valueGroups) {
            if (this.support(valueGroups)) {
                return IndexValueCapability.YES;
            }
            if (this.singleWildcard(valueGroups)) {
                return IndexValueCapability.PARTIAL;
            }
            return IndexValueCapability.NO;
        }

        private boolean singleWildcard(ValueGroup[] valueGroups) {
            return valueGroups.length == 1 && valueGroups[0] == ValueGroup.UNKNOWN;
        }

        private boolean support(ValueGroup[] valueGroups) {
            return valueGroups.length == 1 && valueGroups[0] == ValueGroup.NUMBER;
        }
    }

    private class ReadOnlyMetaNumberLayout
    extends Layout.ReadOnlyMetaLayout {
        private ReadOnlyMetaNumberLayout() {
        }

        public boolean compatibleWith(long layoutIdentifier, int majorVersion, int minorVersion) {
            return layoutIdentifier == NumberLayoutUnique.IDENTIFIER && majorVersion == 0 && minorVersion == 1 || layoutIdentifier == NumberLayoutNonUnique.IDENTIFIER && majorVersion == 0 && minorVersion == 1;
        }
    }
}

