/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.EntityFactory;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.GraphPropertiesProxy;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class NodeManager
extends LifecycleAdapter
implements EntityFactory {
    private final ThreadToStatementContextBridge threadToTransactionBridge;
    private final NodeProxy.NodeActions nodeActions;
    private final RelationshipProxy.RelationshipActions relationshipActions;
    private final GraphPropertiesProxy.GraphPropertiesActions graphPropertiesActions;
    private final GraphDatabaseService graphDatabaseService;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;

    public NodeManager(GraphDatabaseService graphDatabaseService, ThreadToStatementContextBridge threadToTransactionBridge, RelationshipTypeTokenHolder relationshipTypeTokenHolder) {
        this.graphDatabaseService = graphDatabaseService;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.nodeActions = new NodeActionsImpl();
        this.relationshipActions = new RelationshipActionsImpl();
        this.graphPropertiesActions = new GraphPropertiesActionsImpl();
        this.threadToTransactionBridge = threadToTransactionBridge;
    }

    @Override
    public NodeProxy newNodeProxyById(long id) {
        return new NodeProxy(this.nodeActions, id);
    }

    @Override
    public RelationshipProxy newRelationshipProxyById(long id) {
        return new RelationshipProxy(this.relationshipActions, id);
    }

    public RelationshipProxy newRelationshipProxy(long id, long startNodeId, int typeId, long endNodeId) {
        return new RelationshipProxy(this.relationshipActions, id, startNodeId, typeId, endNodeId);
    }

    @Override
    public GraphProperties newGraphProperties() {
        return new GraphPropertiesProxy(this.graphPropertiesActions);
    }

    private class GraphPropertiesActionsImpl
    implements GraphPropertiesProxy.GraphPropertiesActions {
        private GraphPropertiesActionsImpl() {
        }

        @Override
        public GraphDatabaseService getGraphDatabaseService() {
            return NodeManager.this.graphDatabaseService;
        }

        @Override
        public void failTransaction() {
            NodeManager.this.threadToTransactionBridge.getKernelTransactionBoundToThisThread(true).failure();
        }

        @Override
        public Statement statement() {
            return NodeManager.this.threadToTransactionBridge.get();
        }
    }

    private class RelationshipActionsImpl
    implements RelationshipProxy.RelationshipActions {
        private RelationshipActionsImpl() {
        }

        @Override
        public GraphDatabaseService getGraphDatabaseService() {
            return NodeManager.this.graphDatabaseService;
        }

        @Override
        public void failTransaction() {
            NodeManager.this.threadToTransactionBridge.getKernelTransactionBoundToThisThread(true).failure();
        }

        @Override
        public void assertInUnterminatedTransaction() {
            NodeManager.this.threadToTransactionBridge.assertInUnterminatedTransaction();
        }

        @Override
        public Statement statement() {
            return NodeManager.this.threadToTransactionBridge.get();
        }

        @Override
        public Node newNodeProxy(long nodeId) {
            return NodeManager.this.newNodeProxyById(nodeId);
        }

        @Override
        public RelationshipType getRelationshipTypeById(int type) {
            try {
                return (RelationshipType)NodeManager.this.relationshipTypeTokenHolder.getTokenById(type);
            }
            catch (TokenNotFoundException e) {
                throw new NotFoundException((Throwable)e);
            }
        }
    }

    private class NodeActionsImpl
    implements NodeProxy.NodeActions {
        private NodeActionsImpl() {
        }

        @Override
        public Statement statement() {
            return NodeManager.this.threadToTransactionBridge.get();
        }

        @Override
        public KernelTransaction kernelTransaction() {
            return NodeManager.this.threadToTransactionBridge.getKernelTransactionBoundToThisThread(true);
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            return NodeManager.this.graphDatabaseService;
        }

        @Override
        public void assertInUnterminatedTransaction() {
            NodeManager.this.threadToTransactionBridge.assertInUnterminatedTransaction();
        }

        @Override
        public void failTransaction() {
            NodeManager.this.threadToTransactionBridge.getKernelTransactionBoundToThisThread(true).failure();
        }

        @Override
        public Relationship newRelationshipProxy(long id, long startNodeId, int typeId, long endNodeId) {
            return NodeManager.this.newRelationshipProxy(id, startNodeId, typeId, endNodeId);
        }
    }
}

