/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public abstract class FutureAdapter<V>
implements Future<V> {
    public static final Future<Void> VOID = CompletableFuture.completedFuture(null);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <T> Present<T> present(T value) {
        return new Present<T>(value);
    }

    public static <T> Future<T> latchGuardedValue(final Supplier<T> supplier, final CountDownLatch guardedByLatch, final String jobDescription) {
        return new FutureAdapter<T>(){

            @Override
            public boolean isDone() {
                return guardedByLatch.getCount() == 0L;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                guardedByLatch.await();
                return supplier.get();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                if (!guardedByLatch.await(timeout, unit)) {
                    throw new TimeoutException(jobDescription + " didn't complete within " + timeout + " " + (Object)((Object)unit));
                }
                return supplier.get();
            }
        };
    }

    public static Future<Integer> processFuture(final Process process) {
        return new FutureAdapter<Integer>(){

            @Override
            public boolean isDone() {
                return this.tryGetExitValue(process) != null;
            }

            private Integer tryGetExitValue(Process process2) {
                try {
                    return process2.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    return null;
                }
            }

            @Override
            public Integer get() throws InterruptedException {
                return process.waitFor();
            }

            @Override
            public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                long end = System.currentTimeMillis() + unit.toMillis(timeout);
                while (System.currentTimeMillis() < end) {
                    Integer result = this.tryGetExitValue(process);
                    if (result != null) {
                        return result;
                    }
                    Thread.sleep(10L);
                }
                throw new TimeoutException("Process '" + process + "' didn't exit within " + timeout + " " + (Object)((Object)unit));
            }
        };
    }

    public static <T> Future<T> future(Callable<T> task) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<T> future = executor.submit(task);
        executor.shutdown();
        return future;
    }

    @Deprecated
    public static class Present<V>
    extends FutureAdapter<V> {
        private final V value;

        public Present(V value) {
            this.value = value;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public V get(long timeout, TimeUnit unit) {
            return this.value;
        }
    }
}

