/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.function.ToIntFunction;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Inputs {
    private Inputs() {
    }

    public static Input input(final InputIterable<InputNode> nodes, final InputIterable<InputRelationship> relationships, final IdMapper idMapper, final IdGenerator idGenerator, final Collector badCollector, final Input.Estimates estimates) {
        return new Input(){

            @Override
            public InputIterable<InputRelationship> relationships() {
                return relationships;
            }

            @Override
            public InputIterable<InputNode> nodes() {
                return nodes;
            }

            @Override
            public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
                return idMapper;
            }

            @Override
            public IdGenerator idGenerator() {
                return idGenerator;
            }

            @Override
            public Collector badCollector() {
                return badCollector;
            }

            @Override
            public Input.Estimates calculateEstimates(ToIntFunction<Value[]> valueSizeCalculator) {
                return estimates;
            }
        };
    }

    public static Input.Estimates knownEstimates(final long numberOfNodes, final long numberOfRelationships, final long numberOfNodeProperties, final long numberOfRelationshipProperties, final long nodePropertiesSize, final long relationshipPropertiesSize, final long numberOfNodeLabels) {
        return new Input.Estimates(){

            @Override
            public long numberOfNodes() {
                return numberOfNodes;
            }

            @Override
            public long numberOfRelationships() {
                return numberOfRelationships;
            }

            @Override
            public long numberOfNodeProperties() {
                return numberOfNodeProperties;
            }

            @Override
            public long sizeOfNodeProperties() {
                return nodePropertiesSize;
            }

            @Override
            public long numberOfNodeLabels() {
                return numberOfNodeLabels;
            }

            @Override
            public long numberOfRelationshipProperties() {
                return numberOfRelationshipProperties;
            }

            @Override
            public long sizeOfRelationshipProperties() {
                return relationshipPropertiesSize;
            }
        };
    }

    public static int calculatePropertySize(InputEntity entity, ToIntFunction<Value[]> valueSizeCalculator) {
        int size = 0;
        int propertyCount = entity.propertyCount();
        if (propertyCount > 0) {
            Value[] values = new Value[propertyCount];
            for (int i = 0; i < propertyCount; ++i) {
                values[i] = Values.of((Object)entity.propertyValue(i));
            }
            size += valueSizeCalculator.applyAsInt(values);
        }
        return size;
    }
}

