/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;

public class DataStatistics
implements Iterable<Pair<Object, Long>> {
    private final Pair<Object, Long>[] sortedTypes;
    private final long nodeCount;
    private final long propertyCount;

    public DataStatistics(long nodeCount, long propertyCount, Pair<Object, Long>[] sortedTypes) {
        this.nodeCount = nodeCount;
        this.propertyCount = propertyCount;
        this.sortedTypes = sortedTypes;
    }

    @Override
    public Iterator<Pair<Object, Long>> iterator() {
        return Iterators.iterator((Object[])this.sortedTypes);
    }

    public int getNumberOfRelationshipTypes() {
        return this.sortedTypes.length;
    }

    public Pair<Object, Long> get(int index) {
        return this.sortedTypes[index];
    }

    public Set<Object> types(int startingFromType, int upToType) {
        HashSet<Object> types = new HashSet<Object>();
        for (int i = startingFromType; i < upToType; ++i) {
            types.add(this.get(i).first());
        }
        return types;
    }

    public long getNodeCount() {
        return this.nodeCount;
    }

    public long getPropertyCount() {
        return this.propertyCount;
    }

    public long getRelationshipCount() {
        long sum = 0L;
        for (Pair<Object, Long> type : this.sortedTypes) {
            sum += ((Long)type.other()).longValue();
        }
        return sum;
    }

    public String toString() {
        return String.format("Imported:%n  %d nodes%n  %d relationships%n  %d properties", this.nodeCount, this.getRelationshipCount(), this.propertyCount);
    }
}

