/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;

class NodeLabelIndexCursor
extends IndexCursor
implements org.neo4j.internal.kernel.api.NodeLabelIndexCursor,
IndexProgressor.NodeLabelClient {
    private Read read;
    private long node = -1L;
    private LabelSet labels;

    NodeLabelIndexCursor() {
    }

    @Override
    public void initialize(IndexProgressor progressor, boolean providesLabels) {
        super.initialize(progressor);
    }

    @Override
    public boolean acceptNode(long reference, LabelSet labels) {
        this.node = reference;
        this.labels = labels;
        return true;
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    public LabelSet labels() {
        return this.labels;
    }

    @Override
    public void close() {
        super.close();
        this.node = -1L;
        this.labels = null;
        this.read = null;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeLabelIndexCursor[closed state]";
        }
        return "NodeLabelIndexCursor[node=" + this.node + ", labels= " + this.labels + ", underlying record=" + super.toString() + " ]";
    }
}

