/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.api.state.TxState;

abstract class StateDefaults<RO, RW extends RO> {
    StateDefaults() {
    }

    final RO get(TxState state, long key) {
        PrimitiveLongObjectMap<RW> map = this.getMap(state);
        if (map == null) {
            return this.defaultValue();
        }
        Object value = map.get(key);
        return (RO)(value == null ? this.defaultValue() : value);
    }

    final RW getOrCreate(TxState state, long key) {
        Object value;
        PrimitiveLongObjectMap map = this.getMap(state);
        if (map == null) {
            map = Primitive.longObjectMap();
            this.setMap(state, map);
        }
        if ((value = map.get(key)) == null) {
            value = this.createValue(key, state);
            map.put(key, value);
        }
        return (RW)value;
    }

    final Iterable<RO> values(TxState state) {
        PrimitiveLongObjectMap<RW> map = this.getMap(state);
        if (map == null) {
            return Iterables.empty();
        }
        Iterable values = map.values();
        return values;
    }

    abstract PrimitiveLongObjectMap<RW> getMap(TxState var1);

    abstract void setMap(TxState var1, PrimitiveLongObjectMap<RW> var2);

    abstract RW createValue(long var1, TxState var3);

    abstract RO defaultValue();
}

