/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.function.BiConsumer;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.unsafe.impl.batchimport.input.Input;

public class EstimationSanityChecker {
    private final RecordFormats formats;
    private final Monitor monitor;

    public EstimationSanityChecker(RecordFormats formats, Monitor monitor) {
        this.formats = formats;
        this.monitor = monitor;
    }

    public void sanityCheck(Input.Estimates estimates) {
        this.sanityCheckEstimateWithMaxId(estimates.numberOfNodes(), this.formats.node().getMaxId(), this.monitor::nodeCountCapacity);
        this.sanityCheckEstimateWithMaxId(estimates.numberOfRelationships(), this.formats.relationship().getMaxId(), this.monitor::relationshipCountCapacity);
    }

    private void sanityCheckEstimateWithMaxId(long estimate, long max, BiConsumer<Long, Long> reporter) {
        if ((double)estimate > (double)max * 0.8) {
            reporter.accept(max, estimate);
        }
    }

    public static interface Monitor {
        public void nodeCountCapacity(long var1, long var3);

        public void relationshipCountCapacity(long var1, long var3);
    }
}

