/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.logging.Log;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.CountingStoreUpdateMonitor;
import org.neo4j.unsafe.impl.batchimport.DataStatistics;
import org.neo4j.unsafe.impl.batchimport.DeleteDuplicateNodesStage;
import org.neo4j.unsafe.impl.batchimport.IdMapperPreparationStage;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.MemoryUsageStatsProvider;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStage;
import org.neo4j.unsafe.impl.batchimport.NodeDegreeCountStage;
import org.neo4j.unsafe.impl.batchimport.NodeStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupDefragmenter;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkforwardStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkingProgress;
import org.neo4j.unsafe.impl.batchimport.RelationshipStage;
import org.neo4j.unsafe.impl.batchimport.SourceOrCachedInputIterable;
import org.neo4j.unsafe.impl.batchimport.SparseNodeFirstRelationshipStage;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.EstimationSanityChecker;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ImportLogic
implements Closeable {
    private final File storeDir;
    private final FileSystemAbstraction fileSystem;
    private final BatchingNeoStores neoStore;
    private final Configuration config;
    private final Log log;
    private final ExecutionMonitor executionMonitor;
    private final RecordFormats recordFormats;
    protected final CountingStoreUpdateMonitor storeUpdateMonitor = new CountingStoreUpdateMonitor();
    private final long maxMemory;
    private final Dependencies dependencies = new Dependencies();
    private final Map<Class<?>, Object> accessibleState = new HashMap();
    private NodeRelationshipCache nodeRelationshipCache;
    private NodeLabelsCache nodeLabelsCache;
    private long startTime;
    private InputCache inputCache;
    private NumberArrayFactory numberArrayFactory;
    private Collector badCollector;
    private IoMonitor writeMonitor;
    private IdMapper idMapper;
    private IdGenerator idGenerator;
    private InputIterable<InputNode> nodes;
    private InputIterable<InputRelationship> relationships;
    private InputIterable<InputNode> cachedNodes;
    private long peakMemoryUsage;
    private long availableMemoryForLinking;

    public ImportLogic(File storeDir, FileSystemAbstraction fileSystem, BatchingNeoStores neoStore, Configuration config, LogService logService, ExecutionMonitor executionMonitor, RecordFormats recordFormats) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.neoStore = neoStore;
        this.config = config;
        this.recordFormats = recordFormats;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.executionMonitor = ExecutionSupervisors.withDynamicProcessorAssignment(executionMonitor, config);
        this.maxMemory = config.maxMemoryUsage();
    }

    public void initialize(Input input) throws IOException {
        this.log.info("Import starting");
        this.startTime = System.currentTimeMillis();
        this.inputCache = new InputCache(this.fileSystem, this.storeDir, this.recordFormats, this.config);
        this.numberArrayFactory = NumberArrayFactory.auto(this.neoStore.getPageCache(), this.storeDir, this.config.allowCacheAllocationOnHeap());
        this.badCollector = input.badCollector();
        this.writeMonitor = new IoMonitor(this.neoStore.getIoTracer());
        this.idMapper = input.idMapper(this.numberArrayFactory);
        this.idGenerator = input.idGenerator();
        this.nodeRelationshipCache = new NodeRelationshipCache(this.numberArrayFactory, this.config.denseNodeThreshold());
        this.nodes = input.nodes();
        this.relationships = input.relationships();
        this.cachedNodes = SourceOrCachedInputIterable.cachedForSure(this.nodes, this.inputCache.nodes("main", true));
        Input.Estimates inputEstimates = input.calculateEstimates(this.neoStore.getPropertyStore().newValueEncodedSizeCalculator());
        this.sanityCheckEstimatesWithRecordFormat(inputEstimates);
        this.dependencies.satisfyDependencies(inputEstimates, this.idMapper, this.neoStore, this.nodeRelationshipCache);
        if (this.neoStore.determineDoubleRelationshipRecordUnits(inputEstimates)) {
            System.out.println("Will use double record units for all relationships");
        }
        this.executionMonitor.initialize((DependencyResolver)this.dependencies);
    }

    private void sanityCheckEstimatesWithRecordFormat(Input.Estimates inputEstimates) {
        new EstimationSanityChecker(this.recordFormats, new EstimationSanityChecker.Monitor(){

            @Override
            public void nodeCountCapacity(long capacity, long estimatedCount) {
                System.err.printf("WARNING: estimated number of relationships %d may exceed capacity %d of selected record format%n", estimatedCount, capacity);
            }

            @Override
            public void relationshipCountCapacity(long capacity, long estimatedCount) {
                System.err.printf("WARNING: estimated number of nodes %d may exceed capacity %d of selected record format%n", estimatedCount, capacity);
            }
        }).sanityCheck(inputEstimates);
    }

    public <T> T getState(Class<T> type) {
        return type.cast(this.accessibleState.get(type));
    }

    public <T> void putState(T state) {
        this.accessibleState.put(state.getClass(), state);
        this.dependencies.satisfyDependency(state);
    }

    public void importNodes() throws IOException {
        Configuration nodeConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getNodeStore());
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.idMapper);
        NodeStage nodeStage = new NodeStage(nodeConfig, this.writeMonitor, this.nodes, this.idMapper, this.idGenerator, this.neoStore, this.inputCache, this.neoStore.getLabelScanStore(), this.storeUpdateMonitor, memoryUsageStats);
        this.neoStore.startFlushingPageCache();
        this.executeStage(nodeStage);
        this.neoStore.stopFlushingPageCache();
        this.updatePeakMemoryUsage();
    }

    public void prepareIdMapper() {
        if (this.idMapper.needsPreparation()) {
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.idMapper);
            this.executeStage(new IdMapperPreparationStage(this.config, this.idMapper, this.cachedNodes, this.badCollector, memoryUsageStats));
            PrimitiveLongIterator duplicateNodeIds = this.badCollector.leftOverDuplicateNodesIds();
            if (duplicateNodeIds.hasNext()) {
                this.executeStage(new DeleteDuplicateNodesStage(this.config, duplicateNodeIds, this.neoStore));
            }
            this.updatePeakMemoryUsage();
        }
    }

    public void importRelationships() throws IOException {
        Configuration relationshipConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipStore());
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.idMapper);
        RelationshipStage unlinkedRelationshipStage = new RelationshipStage(relationshipConfig, this.writeMonitor, this.relationships, this.idMapper, this.badCollector, this.inputCache, this.neoStore, this.storeUpdateMonitor, memoryUsageStats);
        this.neoStore.startFlushingPageCache();
        this.executeStage(unlinkedRelationshipStage);
        this.neoStore.stopFlushingPageCache();
        this.updatePeakMemoryUsage();
        this.idMapper.close();
        this.idMapper = null;
        this.putState(unlinkedRelationshipStage.getDistribution());
    }

    public void calculateNodeDegrees() {
        Configuration relationshipConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipStore());
        this.nodeRelationshipCache.setNodeCount(this.neoStore.getNodeStore().getHighId());
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.nodeRelationshipCache);
        NodeDegreeCountStage nodeDegreeStage = new NodeDegreeCountStage(relationshipConfig, this.neoStore.getRelationshipStore(), this.nodeRelationshipCache, memoryUsageStats);
        this.executeStage(nodeDegreeStage);
        this.nodeRelationshipCache.countingCompleted();
        this.availableMemoryForLinking = this.maxMemory - ImportLogic.totalMemoryUsageOf(this.nodeRelationshipCache, this.neoStore);
    }

    public int linkRelationships(int startingFromType) {
        assert (startingFromType >= 0) : startingFromType;
        DataStatistics relationshipTypeDistribution = this.getState(DataStatistics.class);
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.nodeRelationshipCache);
        int upToType = ImportLogic.nextSetOfTypesThatFitInMemory(relationshipTypeDistribution, startingFromType, this.availableMemoryForLinking, this.nodeRelationshipCache.getNumberOfDenseNodes());
        Set<Object> typesToLinkThisRound = relationshipTypeDistribution.types(startingFromType, upToType);
        int typesImported = typesToLinkThisRound.size();
        boolean thisIsTheFirstRound = startingFromType == 0;
        boolean thisIsTheOnlyRound = thisIsTheFirstRound && upToType == relationshipTypeDistribution.getNumberOfRelationshipTypes();
        Configuration relationshipConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipStore());
        Configuration nodeConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getNodeStore());
        Configuration groupConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipGroupStore());
        this.nodeRelationshipCache.setForwardScan(true, true);
        String range = typesToLinkThisRound.size() == 1 ? String.valueOf(ImportLogic.oneBased(startingFromType)) : ImportLogic.oneBased(startingFromType) + "-" + (startingFromType + typesImported);
        String topic = " " + range + "/" + relationshipTypeDistribution.getNumberOfRelationshipTypes();
        int nodeTypes = thisIsTheFirstRound ? 3 : 1;
        Predicate<RelationshipRecord> readFilter = thisIsTheFirstRound ? null : ImportLogic.typeIdFilter(typesToLinkThisRound, this.neoStore.getRelationshipTypeRepository());
        Predicate<RelationshipRecord> denseChangeFilter = thisIsTheOnlyRound ? null : ImportLogic.typeIdFilter(typesToLinkThisRound, this.neoStore.getRelationshipTypeRepository());
        RelationshipLinkforwardStage linkForwardStage = new RelationshipLinkforwardStage(topic, relationshipConfig, this.neoStore, this.nodeRelationshipCache, readFilter, denseChangeFilter, nodeTypes, new RelationshipLinkingProgress(), memoryUsageStats);
        this.executeStage(linkForwardStage);
        this.executeStage(new RelationshipGroupStage(topic, groupConfig, this.neoStore.getTemporaryRelationshipGroupStore(), this.nodeRelationshipCache));
        if (thisIsTheFirstRound) {
            this.executeStage(new SparseNodeFirstRelationshipStage(nodeConfig, this.neoStore.getNodeStore(), this.nodeRelationshipCache));
        }
        this.nodeRelationshipCache.setForwardScan(false, true);
        this.executeStage(new RelationshipLinkbackStage(topic, relationshipConfig, this.neoStore, this.nodeRelationshipCache, readFilter, denseChangeFilter, nodeTypes, new RelationshipLinkingProgress(), memoryUsageStats));
        this.updatePeakMemoryUsage();
        if (upToType == relationshipTypeDistribution.getNumberOfRelationshipTypes()) {
            this.nodeRelationshipCache.close();
            this.nodeRelationshipCache = null;
            return -1;
        }
        return upToType;
    }

    public void linkRelationshipsOfAllTypes() {
        int type = 0;
        while ((type = this.linkRelationships(type)) != -1) {
        }
    }

    private static int oneBased(int value) {
        return value + 1;
    }

    static int nextSetOfTypesThatFitInMemory(DataStatistics typeDistribution, int startingFromType, long freeMemoryForDenseNodeCache, long numberOfDenseNodes) {
        Pair<Object, Long> type;
        long relationshipCountForThisType;
        long memoryUsageUpToAndIncludingThisType;
        int toType;
        long memoryUsageForThisType;
        assert (startingFromType >= 0) : startingFromType;
        long currentSetOfRelationshipsMemoryUsage = 0L;
        int numberOfTypes = typeDistribution.getNumberOfRelationshipTypes();
        for (toType = startingFromType; toType < numberOfTypes && ((memoryUsageUpToAndIncludingThisType = currentSetOfRelationshipsMemoryUsage + (memoryUsageForThisType = NodeRelationshipCache.calculateMaxMemoryUsage(numberOfDenseNodes, relationshipCountForThisType = ((Long)(type = typeDistribution.get(toType)).other()).longValue()))) <= freeMemoryForDenseNodeCache || currentSetOfRelationshipsMemoryUsage <= 0L); currentSetOfRelationshipsMemoryUsage += memoryUsageForThisType, ++toType) {
        }
        return toType;
    }

    public void defragmentRelationshipGroups() {
        new RelationshipGroupDefragmenter(this.config, this.executionMonitor, RelationshipGroupDefragmenter.Monitor.EMPTY, this.numberArrayFactory).run(Long.max(this.maxMemory, this.peakMemoryUsage), this.neoStore, this.neoStore.getNodeStore().getHighId());
    }

    public void buildCountsStore() {
        try (CountsAccessor.Updater countsUpdater = this.neoStore.getCountsStore().reset(this.neoStore.getLastCommittedTransactionId());){
            SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
            this.nodeLabelsCache = new NodeLabelsCache(this.numberArrayFactory, this.neoStore.getLabelRepository().getHighId());
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(this.neoStore, this.nodeLabelsCache);
            this.executeStage(new NodeCountsStage(this.config, this.nodeLabelsCache, this.neoStore.getNodeStore(), this.neoStore.getLabelRepository().getHighId(), countsUpdater, progressMonitor.startSection("Nodes"), memoryUsageStats));
            this.executeStage(new RelationshipCountsStage(this.config, this.nodeLabelsCache, this.neoStore.getRelationshipStore(), this.neoStore.getLabelRepository().getHighId(), this.neoStore.getRelationshipTypeRepository().getHighId(), countsUpdater, this.numberArrayFactory, progressMonitor.startSection("Relationships")));
        }
    }

    @Override
    public void close() throws IOException {
        long totalTimeMillis = System.currentTimeMillis() - this.startTime;
        DataStatistics stats = this.getState(DataStatistics.class);
        this.executionMonitor.done(totalTimeMillis, String.format("%n%s%nPeak memory usage: %s", stats, Format.bytes(this.peakMemoryUsage)));
        this.log.info("Import completed successfully, took " + Format.duration(totalTimeMillis) + ". " + stats);
        if (this.nodeRelationshipCache != null) {
            this.nodeRelationshipCache.close();
        }
        if (this.nodeLabelsCache != null) {
            this.nodeLabelsCache.close();
        }
        if (this.idMapper != null) {
            this.idMapper.close();
        }
        this.inputCache.close();
    }

    private void updatePeakMemoryUsage() {
        this.peakMemoryUsage = Long.max(this.peakMemoryUsage, ImportLogic.totalMemoryUsageOf(this.nodeRelationshipCache, this.idMapper, this.neoStore));
    }

    public static BatchingNeoStores instantiateNeoStores(FileSystemAbstraction fileSystem, File storeDir, PageCache externalPageCache, RecordFormats recordFormats, Configuration config, LogService logService, AdditionalInitialIds additionalInitialIds, Config dbConfig) {
        if (externalPageCache == null) {
            return BatchingNeoStores.batchingNeoStores(fileSystem, storeDir, recordFormats, config, logService, additionalInitialIds, dbConfig);
        }
        return BatchingNeoStores.batchingNeoStoresWithExternalPageCache(fileSystem, externalPageCache, PageCacheTracer.NULL, storeDir, recordFormats, config, logService, additionalInitialIds, dbConfig);
    }

    private static long totalMemoryUsageOf(MemoryStatsVisitor.Visitable ... users) {
        GatheringMemoryStatsVisitor total = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable user : users) {
            if (user == null) continue;
            user.acceptMemoryStatsVisitor(total);
        }
        return total.getHeapUsage() + total.getOffHeapUsage();
    }

    private static Predicate<RelationshipRecord> typeIdFilter(Collection<Object> typesToLinkThisRound, BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository) {
        PrimitiveIntSet set = Primitive.intSet((int)typesToLinkThisRound.size());
        for (Object type : typesToLinkThisRound) {
            int id = type instanceof Number ? ((Number)type).intValue() : relationshipTypeRepository.applyAsInt(type);
            set.add(id);
        }
        return relationship -> set.contains(relationship.getType());
    }

    private static Configuration configWithRecordsPerPageBasedBatchSize(Configuration source, RecordStore<?> store) {
        return Configuration.withBatchSize(source, store.getRecordsPerPage() * 10);
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, this.config, stage);
    }
}

