/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.concurrent.atomic.LongAdder;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;

public class CountingStoreUpdateMonitor
implements EntityStoreUpdaterStep.Monitor {
    private final LongAdder nodes = new LongAdder();
    private final LongAdder relationships = new LongAdder();
    private final LongAdder properties = new LongAdder();

    @Override
    public void entitiesWritten(Class<? extends PrimitiveRecord> type, long count) {
        if (type.equals(NodeRecord.class)) {
            this.nodes.add(count);
        } else if (type.equals(RelationshipRecord.class)) {
            this.relationships.add(count);
        } else {
            throw new IllegalArgumentException(type.getName());
        }
    }

    @Override
    public void propertiesWritten(long count) {
        this.properties.add(count);
    }

    public long propertiesWritten() {
        return this.properties.sum();
    }

    public long nodesWritten() {
        return this.nodes.sum();
    }

    public long relationshipsWritten() {
        return this.relationships.sum();
    }
}

