/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LogPruningImpl
implements LogPruning {
    private final Lock pruneLock = new ReentrantLock();
    private final FileSystemAbstraction fs;
    private final LogPruneStrategy pruneStrategy;
    private final LogFiles logFiles;
    private final Log msgLog;

    public LogPruningImpl(FileSystemAbstraction fs, LogPruneStrategy pruneStrategy, LogFiles logFiles, LogProvider logProvider) {
        this.fs = fs;
        this.pruneStrategy = pruneStrategy;
        this.logFiles = logFiles;
        this.msgLog = logProvider.getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneLogs(long upToVersion) {
        if (this.pruneLock.tryLock()) {
            try {
                CountingDeleter deleter = new CountingDeleter(this.logFiles, this.fs, upToVersion);
                this.pruneStrategy.findLogVersionsToDelete(upToVersion).forEachOrdered(deleter);
                this.msgLog.info(deleter.describeResult());
            }
            finally {
                this.pruneLock.unlock();
            }
        }
    }

    @Override
    public boolean mightHaveLogsToPrune() {
        return this.pruneStrategy.findLogVersionsToDelete(this.logFiles.getHighestLogVersion()).count() > 0L;
    }

    private static class CountingDeleter
    implements LongConsumer {
        private static final int NO_VERSION = -1;
        private final LogFiles logFiles;
        private final FileSystemAbstraction fs;
        private final long upToVersion;
        private long fromVersion;
        private long toVersion;

        private CountingDeleter(LogFiles logFiles, FileSystemAbstraction fs, long upToVersion) {
            this.logFiles = logFiles;
            this.fs = fs;
            this.upToVersion = upToVersion;
            this.fromVersion = -1L;
            this.toVersion = -1L;
        }

        @Override
        public void accept(long version) {
            this.fromVersion = this.fromVersion == -1L ? version : Math.min(this.fromVersion, version);
            this.toVersion = this.toVersion == -1L ? version : Math.max(this.toVersion, version);
            File logFile = this.logFiles.getLogFileForVersion(version);
            this.fs.deleteFile(logFile);
        }

        public String describeResult() {
            if (this.fromVersion == -1L) {
                return "No log version pruned, last checkpoint was made in version " + this.upToVersion;
            }
            return "Pruned log versions " + this.fromVersion + "-" + this.toVersion + ", last checkpoint was made in version " + this.upToVersion;
        }
    }
}

