/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipCursor;

class RelationshipScanCursor
extends RelationshipCursor
implements org.neo4j.internal.kernel.api.RelationshipScanCursor {
    private int label;
    private long next;
    private long highMark;
    private PageCursor pageCursor;

    RelationshipScanCursor() {
    }

    void scan(int label, Read read) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = read.relationshipPage(0L);
        }
        this.next = 0L;
        this.label = label;
        this.highMark = read.relationshipHighMark();
        this.read = read;
    }

    void single(long reference, Read read) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = read.relationshipPage(reference);
        }
        this.next = reference;
        this.label = -1;
        this.highMark = -1L;
        this.read = read;
    }

    public boolean next() {
        do {
            if (this.next == -1L) {
                this.reset();
                return false;
            }
            do {
                this.read.relationship(this, this.next++, this.pageCursor);
                if (this.next <= this.highMark) continue;
                if (this.highMark == -1L) {
                    this.next = -1L;
                    return (this.label == -1 || this.label() == this.label) && this.inUse();
                }
                this.highMark = this.read.relationshipHighMark();
                if (this.next <= this.highMark) continue;
                this.next = -1L;
                return (this.label == -1 || this.label() == this.label) && this.inUse();
            } while (!this.inUse());
        } while (this.label != -1 && this.label() != this.label);
        return true;
    }

    public boolean shouldRetry() {
        return false;
    }

    public void close() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
        this.read = null;
        this.reset();
    }

    private void reset() {
        this.next = -1L;
        this.setId(-1L);
    }

    public boolean isClosed() {
        return this.pageCursor == null;
    }

    @Override
    public String toString() {
        if (this.isClosed()) {
            return "RelationshipScanCursor[closed state]";
        }
        return "RelationshipScanCursor[id=" + this.getId() + ", open state with: highMark=" + this.highMark + ", next=" + this.next + ", label=" + this.label + ", underlying record=" + super.toString() + " ]";
    }
}

