/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

abstract class RelationshipCursor
extends RelationshipRecord
implements RelationshipDataAccessor {
    Read read;

    RelationshipCursor() {
        super(-1L);
    }

    public long relationshipReference() {
        return this.getId();
    }

    public int label() {
        return this.getType();
    }

    public boolean hasProperties() {
        return this.nextProp != -1L;
    }

    public void source(NodeCursor cursor) {
        this.read.singleNode(this.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.read.singleNode(this.targetNodeReference(), cursor);
    }

    public void properties(PropertyCursor cursor) {
        this.read.nodeProperties(this.propertiesReference(), cursor);
    }

    public long sourceNodeReference() {
        return this.getFirstNode();
    }

    public long targetNodeReference() {
        return this.getSecondNode();
    }

    public long propertiesReference() {
        return this.getNextProp();
    }
}

