/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.impl.newapi.Read;

class NodeSchemaMatcher {
    private final Read read;

    NodeSchemaMatcher(Read read) {
        this.read = read;
    }

    <SUPPLIER extends LabelSchemaSupplier, EXCEPTION extends Exception> void onMatchingSchema(Iterator<SUPPLIER> schemaSuppliers, NodeCursor node, PropertyCursor property, int specialPropertyId, ThrowingBiConsumer<SUPPLIER, PrimitiveIntSet, EXCEPTION> callback) throws EXCEPTION {
        PrimitiveIntSet nodePropertyIds = null;
        while (schemaSuppliers.hasNext()) {
            LabelSchemaSupplier schemaSupplier = (LabelSchemaSupplier)schemaSuppliers.next();
            LabelSchemaDescriptor schema = schemaSupplier.schema();
            if (!node.labels().contains(schema.getLabelId())) continue;
            if (nodePropertyIds == null) {
                nodePropertyIds = Primitive.intSet();
                node.properties(property);
                while (property.next()) {
                    nodePropertyIds.add(property.propertyKey());
                }
            }
            if (!NodeSchemaMatcher.nodeHasSchemaProperties(nodePropertyIds, schema.getPropertyIds(), specialPropertyId)) continue;
            callback.accept((Object)schemaSupplier, (Object)nodePropertyIds);
        }
    }

    private static boolean nodeHasSchemaProperties(PrimitiveIntSet nodeProperties, int[] indexPropertyIds, int changedPropertyId) {
        for (int indexPropertyId : indexPropertyIds) {
            if (indexPropertyId == changedPropertyId || nodeProperties.contains(indexPropertyId)) continue;
            return false;
        }
        return true;
    }
}

