/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ExecutionStatisticsOperations;
import org.neo4j.kernel.api.ExplicitIndexHits;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ProcedureCallOperations;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.operations.CountsOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.ExplicitIndexReadOperations;
import org.neo4j.kernel.impl.api.operations.ExplicitIndexWriteOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.QueryRegistrationOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.api.store.CursorRelationshipIterator;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class OperationsFacade
implements ReadOperations,
DataWriteOperations,
TokenWriteOperations,
org.neo4j.kernel.api.SchemaWriteOperations,
QueryRegistryOperations,
ProcedureCallOperations,
ExecutionStatisticsOperations {
    private final KernelTransaction tx;
    private final KernelStatement statement;
    private final Procedures procedures;
    private StatementOperationParts operations;

    OperationsFacade(KernelTransaction tx, KernelStatement statement, Procedures procedures, StatementOperationParts operationParts) {
        this.tx = tx;
        this.statement = statement;
        this.procedures = procedures;
        this.operations = operationParts;
    }

    final KeyReadOperations tokenRead() {
        return this.operations.keyReadOperations();
    }

    final KeyWriteOperations tokenWrite() {
        this.statement.assertAllows(AccessMode::allowsTokenCreates, "Token create");
        return this.operations.keyWriteOperations();
    }

    final EntityReadOperations dataRead() {
        return this.operations.entityReadOperations();
    }

    final EntityWriteOperations dataWrite() {
        return this.operations.entityWriteOperations();
    }

    final ExplicitIndexWriteOperations explicitIndexWrite() {
        return this.operations.explicitIndexWriteOperations();
    }

    final ExplicitIndexReadOperations explicitIndexRead() {
        return this.operations.explicitIndexReadOperations();
    }

    final SchemaReadOperations schemaRead() {
        return this.operations.schemaReadOperations();
    }

    final SchemaWriteOperations schemaWrite() {
        return this.operations.schemaWriteOperations();
    }

    final QueryRegistrationOperations queryRegistrationOperations() {
        return this.operations.queryRegistrationOperations();
    }

    final SchemaStateOperations schemaState() {
        return this.operations.schemaStateOperations();
    }

    final LockOperations locking() {
        return this.operations.locking();
    }

    final CountsOperations counting() {
        return this.operations.counting();
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        this.statement.assertOpen();
        return this.dataRead().nodesGetAll(this.statement);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll() {
        this.statement.assertOpen();
        return this.dataRead().relationshipsGetAll(this.statement);
    }

    @Override
    public PrimitiveLongResourceIterator nodesGetForLabel(int labelId) {
        this.statement.assertOpen();
        if (labelId == -1) {
            return PrimitiveLongResourceCollections.emptyIterator();
        }
        return this.dataRead().nodesGetForLabel(this.statement, labelId);
    }

    @Override
    public PrimitiveLongResourceIterator indexQuery(IndexDescriptor index, IndexQuery ... predicates) throws IndexNotFoundKernelException, IndexNotApplicableKernelException {
        this.statement.assertOpen();
        return this.dataRead().indexQuery(this.statement, index, predicates);
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(IndexDescriptor index, IndexQuery.ExactPredicate ... predicates) throws IndexNotFoundKernelException, IndexBrokenKernelException, IndexNotApplicableKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetFromUniqueIndexSeek(this.statement, index, predicates);
    }

    @Override
    public boolean nodeExists(long nodeId) {
        this.statement.assertOpen();
        return this.dataRead().nodeExists(this.statement, nodeId);
    }

    @Override
    public boolean nodeHasLabel(long nodeId, int labelId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (labelId == -1) {
            return false;
        }
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            boolean bl = ((NodeItem)node.get()).hasLabel(labelId);
            return bl;
        }
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            PrimitiveIntIterator primitiveIntIterator = ((NodeItem)node.get()).labels().iterator();
            return primitiveIntIterator;
        }
    }

    @Override
    public boolean nodeHasProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return false;
        }
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            boolean bl = this.dataRead().nodeHasProperty(this.statement, (NodeItem)node.get(), propertyKeyId);
            return bl;
        }
    }

    @Override
    public Value nodeGetProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Values.NO_VALUE;
        }
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            Value value = this.dataRead().nodeGetProperty(this.statement, (NodeItem)node.get(), propertyKeyId);
            return value;
        }
    }

    @Override
    public RelationshipIterator nodeGetRelationships(long nodeId, Direction direction, int[] relTypes) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            CursorRelationshipIterator cursorRelationshipIterator = new CursorRelationshipIterator(this.dataRead().nodeGetRelationships(this.statement, (NodeItem)node.get(), this.direction(direction), PrimitiveIntCollections.deduplicate((int[])relTypes)));
            return cursorRelationshipIterator;
        }
    }

    private org.neo4j.storageengine.api.Direction direction(Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return org.neo4j.storageengine.api.Direction.OUTGOING;
            }
            case INCOMING: {
                return org.neo4j.storageengine.api.Direction.INCOMING;
            }
            case BOTH: {
                return org.neo4j.storageengine.api.Direction.BOTH;
            }
        }
        throw new IllegalArgumentException(direction.name());
    }

    @Override
    public RelationshipIterator nodeGetRelationships(long nodeId, Direction direction) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            CursorRelationshipIterator cursorRelationshipIterator = new CursorRelationshipIterator(this.dataRead().nodeGetRelationships(this.statement, (NodeItem)node.get(), this.direction(direction)));
            return cursorRelationshipIterator;
        }
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            int n = this.dataRead().degree(this.statement, (NodeItem)node.get(), this.direction(direction), relType);
            return n;
        }
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            int n = this.dataRead().degree(this.statement, (NodeItem)node.get(), this.direction(direction));
            return n;
        }
    }

    @Override
    public boolean nodeIsDense(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            boolean bl = ((NodeItem)node.get()).isDense();
            return bl;
        }
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            PrimitiveIntIterator primitiveIntIterator = this.dataRead().relationshipTypes(this.statement, (NodeItem)node.get()).iterator();
            return primitiveIntIterator;
        }
    }

    @Override
    public boolean relationshipHasProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return false;
        }
        try (Cursor<RelationshipItem> relationship = this.dataRead().relationshipCursorById(this.statement, relationshipId);){
            boolean bl = this.dataRead().relationshipHasProperty(this.statement, (RelationshipItem)relationship.get(), propertyKeyId);
            return bl;
        }
    }

    @Override
    public Value relationshipGetProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Values.NO_VALUE;
        }
        try (Cursor<RelationshipItem> relationship = this.dataRead().relationshipCursorById(this.statement, relationshipId);){
            Value value = this.dataRead().relationshipGetProperty(this.statement, (RelationshipItem)relationship.get(), propertyKeyId);
            return value;
        }
    }

    @Override
    public boolean graphHasProperty(int propertyKeyId) {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return false;
        }
        return this.dataRead().graphHasProperty(this.statement, propertyKeyId);
    }

    @Override
    public Value graphGetProperty(int propertyKeyId) {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Values.NO_VALUE;
        }
        return this.dataRead().graphGetProperty(this.statement, propertyKeyId);
    }

    @Override
    public PrimitiveIntIterator nodeGetPropertyKeys(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            PrimitiveIntIterator primitiveIntIterator = this.dataRead().nodeGetPropertyKeys(this.statement, (NodeItem)node.get()).iterator();
            return primitiveIntIterator;
        }
    }

    @Override
    public PrimitiveIntIterator relationshipGetPropertyKeys(long relationshipId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<RelationshipItem> relationship = this.dataRead().relationshipCursorById(this.statement, relationshipId);){
            PrimitiveIntIterator primitiveIntIterator = this.dataRead().relationshipGetPropertyKeys(this.statement, (RelationshipItem)relationship.get()).iterator();
            return primitiveIntIterator;
        }
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys() {
        this.statement.assertOpen();
        return this.dataRead().graphGetPropertyKeys(this.statement);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.statement.assertOpen();
        this.dataRead().relationshipVisit(this.statement, relId, visitor);
    }

    @Override
    public long nodesGetCount() {
        this.statement.assertOpen();
        return this.dataRead().nodesGetCount(this.statement);
    }

    @Override
    public long relationshipsGetCount() {
        this.statement.assertOpen();
        return this.dataRead().relationshipsGetCount(this.statement);
    }

    @Override
    public ProcedureSignature procedureGet(QualifiedName name) throws ProcedureException {
        this.statement.assertOpen();
        return this.procedures.procedure(name);
    }

    @Override
    public Optional<UserFunctionSignature> functionGet(QualifiedName name) {
        this.statement.assertOpen();
        return this.procedures.function(name);
    }

    @Override
    public Optional<UserFunctionSignature> aggregationFunctionGet(QualifiedName name) {
        this.statement.assertOpen();
        return this.procedures.aggregationFunction(name);
    }

    @Override
    public Set<UserFunctionSignature> functionsGetAll() {
        this.statement.assertOpen();
        return this.procedures.getAllFunctions();
    }

    @Override
    public Set<ProcedureSignature> proceduresGetAll() {
        this.statement.assertOpen();
        return this.procedures.getAllProcedures();
    }

    @Override
    public long nodesCountIndexed(IndexDescriptor index, long nodeId, Value value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesCountIndexed(this.statement, index, nodeId, value);
    }

    @Override
    public Cursor<NodeItem> nodeCursorById(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeCursorById(this.statement, nodeId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorById(long relId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().relationshipCursorById(this.statement, relId);
    }

    @Override
    public Cursor<PropertyItem> nodeGetProperties(NodeItem node) {
        this.statement.assertOpen();
        return this.dataRead().nodeGetProperties(this.statement, node);
    }

    @Override
    public Cursor<PropertyItem> relationshipGetProperties(RelationshipItem relationship) {
        this.statement.assertOpen();
        return this.dataRead().relationshipGetProperties(this.statement, relationship);
    }

    @Override
    public IndexDescriptor indexGetForSchema(LabelSchemaDescriptor descriptor) throws SchemaRuleNotFoundException {
        this.statement.assertOpen();
        IndexDescriptor indexDescriptor = this.schemaRead().indexGetForSchema(this.statement, descriptor);
        if (indexDescriptor == null) {
            throw new SchemaRuleNotFoundException(SchemaRule.Kind.INDEX_RULE, descriptor);
        }
        return indexDescriptor;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().indexesGetForLabel(this.statement, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().indexesGetAll(this.statement);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        this.statement.assertOpen();
        return this.schemaRead().indexGetOwningUniquenessConstraintId(this.statement, index);
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetState(this.statement, descriptor);
    }

    @Override
    public SchemaIndexProvider.Descriptor indexGetProviderDescriptor(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetProviderDescriptor(this.statement, descriptor);
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetPopulationProgress(this.statement, descriptor);
    }

    @Override
    public long indexSize(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexSize(this.statement, descriptor);
    }

    @Override
    public double indexUniqueValuesSelectivity(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexUniqueValuesPercentage(this.statement, descriptor);
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetFailure(this.statement, descriptor);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForSchema(this.statement, descriptor);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForLabel(this.statement, labelId);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForRelationshipType(this.statement, typeId);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetAll(this.statement);
    }

    @Override
    public int labelGetForName(String labelName) {
        this.statement.assertOpen();
        return this.tokenRead().labelGetForName(this.statement, labelName);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().labelGetName(this.statement, labelId);
    }

    @Override
    public int propertyKeyGetForName(String propertyKeyName) {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetForName(this.statement, propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetName(this.statement, propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetAllTokens(this.statement);
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().labelsGetAllTokens(this.statement);
    }

    @Override
    public Iterator<Token> relationshipTypesGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypesGetAllTokens(this.statement);
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeGetForName(this.statement, relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeGetName(this.statement, relationshipTypeId);
    }

    @Override
    public int labelCount() {
        this.statement.assertOpen();
        return this.tokenRead().labelCount(this.statement);
    }

    @Override
    public int propertyKeyCount() {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyCount(this.statement);
    }

    @Override
    public int relationshipTypeCount() {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeCount(this.statement);
    }

    @Override
    public int labelGetOrCreateForName(String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        this.statement.assertOpen();
        int id = this.tokenRead().labelGetForName(this.statement, labelName);
        if (id != -1) {
            return id;
        }
        return this.tokenWrite().labelGetOrCreateForName(this.statement, labelName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws IllegalTokenNameException {
        this.statement.assertOpen();
        int id = this.tokenRead().propertyKeyGetForName(this.statement, propertyKeyName);
        if (id != -1) {
            return id;
        }
        return this.tokenWrite().propertyKeyGetOrCreateForName(this.statement, propertyKeyName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws IllegalTokenNameException {
        this.statement.assertOpen();
        int id = this.tokenRead().relationshipTypeGetForName(this.statement, relationshipTypeName);
        if (id != -1) {
            return id;
        }
        return this.tokenWrite().relationshipTypeGetOrCreateForName(this.statement, relationshipTypeName);
    }

    @Override
    public void labelCreateForName(String labelName, int id) throws IllegalTokenNameException, TooManyLabelsException {
        this.statement.assertOpen();
        this.tokenWrite().labelCreateForName(this.statement, labelName, id);
    }

    @Override
    public void propertyKeyCreateForName(String propertyKeyName, int id) throws IllegalTokenNameException {
        this.statement.assertOpen();
        this.tokenWrite().propertyKeyCreateForName(this.statement, propertyKeyName, id);
    }

    @Override
    public void relationshipTypeCreateForName(String relationshipTypeName, int id) throws IllegalTokenNameException {
        this.statement.assertOpen();
        this.tokenWrite().relationshipTypeCreateForName(this.statement, relationshipTypeName, id);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return this.schemaState().schemaStateGetOrCreate(this.statement, key, creator);
    }

    @Override
    public <K, V> V schemaStateGet(K key) {
        return this.schemaState().schemaStateGet(this.statement, key);
    }

    @Override
    public void schemaStateFlush() {
        this.schemaState().schemaStateFlush(this.statement);
    }

    @Override
    public long nodeCreate() {
        this.statement.assertOpen();
        return this.dataWrite().nodeCreate(this.statement);
    }

    @Override
    public void nodeDelete(long nodeId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        this.statement.assertOpen();
        this.dataWrite().nodeDelete(this.statement, nodeId);
    }

    @Override
    public int nodeDetachDelete(long nodeId) throws KernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeDetachDelete(this.statement, nodeId);
    }

    @Override
    public long relationshipCreate(int relationshipTypeId, long startNodeId, long endNodeId) throws RelationshipTypeIdNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipCreate(this.statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(long relationshipId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        this.statement.assertOpen();
        this.dataWrite().relationshipDelete(this.statement, relationshipId);
    }

    @Override
    public boolean nodeAddLabel(long nodeId, int labelId) throws EntityNotFoundException, ConstraintValidationException {
        this.statement.assertOpen();
        return this.dataWrite().nodeAddLabel(this.statement, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(long nodeId, int labelId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().nodeRemoveLabel(this.statement, nodeId, labelId);
    }

    @Override
    public Value nodeSetProperty(long nodeId, int propertyKeyId, Value value) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException, ConstraintValidationException {
        this.statement.assertOpen();
        return this.dataWrite().nodeSetProperty(this.statement, nodeId, propertyKeyId, value);
    }

    @Override
    public Value relationshipSetProperty(long relationshipId, int propertyKeyId, Value value) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipSetProperty(this.statement, relationshipId, propertyKeyId, value);
    }

    @Override
    public Value graphSetProperty(int propertyKeyId, Value value) {
        this.statement.assertOpen();
        return this.dataWrite().graphSetProperty(this.statement, propertyKeyId, value);
    }

    @Override
    public Value nodeRemoveProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeRemoveProperty(this.statement, nodeId, propertyKeyId);
    }

    @Override
    public Value relationshipRemoveProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipRemoveProperty(this.statement, relationshipId, propertyKeyId);
    }

    @Override
    public Value graphRemoveProperty(int propertyKeyId) {
        this.statement.assertOpen();
        return this.dataWrite().graphRemoveProperty(this.statement, propertyKeyId);
    }

    @Override
    public IndexDescriptor indexCreate(LabelSchemaDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException, RepeatedPropertyInCompositeSchemaException {
        this.statement.assertOpen();
        return this.schemaWrite().indexCreate(this.statement, descriptor);
    }

    @Override
    public void indexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.statement.assertOpen();
        this.schemaWrite().indexDrop(this.statement, descriptor);
    }

    @Override
    public NodeKeyConstraintDescriptor nodeKeyConstraintCreate(LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException, RepeatedPropertyInCompositeSchemaException {
        this.statement.assertOpen();
        return this.schemaWrite().nodeKeyConstraintCreate(this.statement, descriptor);
    }

    @Override
    public UniquenessConstraintDescriptor uniquePropertyConstraintCreate(LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException, RepeatedPropertyInCompositeSchemaException {
        this.statement.assertOpen();
        return this.schemaWrite().uniquePropertyConstraintCreate(this.statement, descriptor);
    }

    @Override
    public NodeExistenceConstraintDescriptor nodePropertyExistenceConstraintCreate(LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException, AlreadyConstrainedException, RepeatedPropertyInCompositeSchemaException {
        this.statement.assertOpen();
        return this.schemaWrite().nodePropertyExistenceConstraintCreate(this.statement, descriptor);
    }

    @Override
    public RelExistenceConstraintDescriptor relationshipPropertyExistenceConstraintCreate(RelationTypeSchemaDescriptor descriptor) throws CreateConstraintFailureException, AlreadyConstrainedException, RepeatedPropertyInCompositeSchemaException {
        this.statement.assertOpen();
        return this.schemaWrite().relationshipPropertyExistenceConstraintCreate(this.statement, descriptor);
    }

    @Override
    public void constraintDrop(ConstraintDescriptor constraint) throws DropConstraintFailureException {
        this.statement.assertOpen();
        this.schemaWrite().constraintDrop(this.statement, constraint);
    }

    @Override
    public void acquireExclusive(ResourceType type, long ... ids) {
        this.statement.assertOpen();
        this.locking().acquireExclusive(this.statement, type, ids);
    }

    @Override
    public void acquireShared(ResourceType type, long ... ids) {
        this.statement.assertOpen();
        this.locking().acquireShared(this.statement, type, ids);
    }

    @Override
    public void releaseExclusive(ResourceType type, long ... ids) {
        this.statement.assertOpen();
        this.locking().releaseExclusive(this.statement, type, ids);
    }

    @Override
    public void releaseShared(ResourceType type, long ... ids) {
        this.statement.assertOpen();
        this.locking().releaseShared(this.statement, type, ids);
    }

    @Override
    public boolean nodeExplicitIndexExists(String indexName, Map<String, String> customConfiguration) {
        this.statement.assertOpen();
        return this.explicitIndexRead().nodeExplicitIndexExists(this.statement, indexName, customConfiguration);
    }

    @Override
    public boolean relationshipExplicitIndexExists(String indexName, Map<String, String> customConfiguration) {
        this.statement.assertOpen();
        return this.explicitIndexRead().relationshipExplicitIndexExists(this.statement, indexName, customConfiguration);
    }

    @Override
    public ExplicitIndexHits nodeExplicitIndexGet(String indexName, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexRead().nodeExplicitIndexGet(this.statement, indexName, key, value);
    }

    @Override
    public ExplicitIndexHits nodeExplicitIndexQuery(String indexName, String key, Object queryOrQueryObject) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexRead().nodeExplicitIndexQuery(this.statement, indexName, key, queryOrQueryObject);
    }

    @Override
    public ExplicitIndexHits nodeExplicitIndexQuery(String indexName, Object queryOrQueryObject) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexRead().nodeExplicitIndexQuery(this.statement, indexName, queryOrQueryObject);
    }

    @Override
    public ExplicitIndexHits relationshipExplicitIndexGet(String indexName, String key, Object value, long startNode, long endNode) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexRead().relationshipExplicitIndexGet(this.statement, indexName, key, value, startNode, endNode);
    }

    @Override
    public ExplicitIndexHits relationshipExplicitIndexQuery(String indexName, String key, Object queryOrQueryObject, long startNode, long endNode) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexRead().relationshipExplicitIndexQuery(this.statement, indexName, key, queryOrQueryObject, startNode, endNode);
    }

    @Override
    public ExplicitIndexHits relationshipExplicitIndexQuery(String indexName, Object queryOrQueryObject, long startNode, long endNode) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexRead().relationshipExplicitIndexQuery(this.statement, indexName, queryOrQueryObject, startNode, endNode);
    }

    public void nodeExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.explicitIndexWrite().nodeExplicitIndexCreateLazily(this.statement, indexName, customConfig);
    }

    public void nodeExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.explicitIndexWrite().nodeExplicitIndexCreate(this.statement, indexName, customConfig);
    }

    public void relationshipExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.explicitIndexWrite().relationshipExplicitIndexCreateLazily(this.statement, indexName, customConfig);
    }

    public void relationshipExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.explicitIndexWrite().relationshipExplicitIndexCreate(this.statement, indexName, customConfig);
    }

    @Override
    public void nodeAddToExplicitIndex(String indexName, long node, String key, Object value) throws EntityNotFoundException, ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.explicitIndexWrite().nodeAddToExplicitIndex(this.statement, indexName, node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.explicitIndexWrite().nodeRemoveFromExplicitIndex(this.statement, indexName, node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.explicitIndexWrite().nodeRemoveFromExplicitIndex(this.statement, indexName, node, key);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.explicitIndexWrite().nodeRemoveFromExplicitIndex(this.statement, indexName, node);
    }

    @Override
    public void relationshipAddToExplicitIndex(String indexName, long relationship, String key, Object value) throws EntityNotFoundException, ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.explicitIndexWrite().relationshipAddToExplicitIndex(this.statement, indexName, relationship, key, value);
    }

    @Override
    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key, Object value) throws EntityNotFoundException, ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.explicitIndexWrite().relationshipRemoveFromExplicitIndex(this.statement, indexName, relationship, key, value);
    }

    @Override
    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        this.explicitIndexWrite().relationshipRemoveFromExplicitIndex(this.statement, indexName, relationship, key);
    }

    @Override
    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        this.explicitIndexWrite().relationshipRemoveFromExplicitIndex(this.statement, indexName, relationship);
    }

    @Override
    public void nodeExplicitIndexDrop(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.explicitIndexWrite().nodeExplicitIndexDrop(this.statement, indexName);
    }

    @Override
    public void relationshipExplicitIndexDrop(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.explicitIndexWrite().relationshipExplicitIndexDrop(this.statement, indexName);
    }

    @Override
    public Map<String, String> nodeExplicitIndexGetConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexRead().nodeExplicitIndexGetConfiguration(this.statement, indexName);
    }

    @Override
    public Map<String, String> relationshipExplicitIndexGetConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexRead().relationshipExplicitIndexGetConfiguration(this.statement, indexName);
    }

    @Override
    public String nodeExplicitIndexSetConfiguration(String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexWrite().nodeExplicitIndexSetConfiguration(this.statement, indexName, key, value);
    }

    @Override
    public String relationshipExplicitIndexSetConfiguration(String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexWrite().relationshipExplicitIndexSetConfiguration(this.statement, indexName, key, value);
    }

    @Override
    public String nodeExplicitIndexRemoveConfiguration(String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexWrite().nodeExplicitIndexRemoveConfiguration(this.statement, indexName, key);
    }

    @Override
    public String relationshipExplicitIndexRemoveConfiguration(String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.explicitIndexWrite().relationshipExplicitIndexRemoveConfiguration(this.statement, indexName, key);
    }

    @Override
    public String[] nodeExplicitIndexesGetAll() {
        this.statement.assertOpen();
        return this.explicitIndexRead().nodeExplicitIndexesGetAll(this.statement);
    }

    @Override
    public String[] relationshipExplicitIndexesGetAll() {
        this.statement.assertOpen();
        return this.explicitIndexRead().relationshipExplicitIndexesGetAll(this.statement);
    }

    @Override
    public long countsForNode(int labelId) {
        this.statement.assertOpen();
        return this.counting().countsForNode(this.statement, labelId);
    }

    @Override
    public long countsForNodeWithoutTxState(int labelId) {
        this.statement.assertOpen();
        return this.counting().countsForNodeWithoutTxState(this.statement, labelId);
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        this.statement.assertOpen();
        return this.counting().countsForRelationship(this.statement, startLabelId, typeId, endLabelId);
    }

    @Override
    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        this.statement.assertOpen();
        return this.counting().countsForRelationshipWithoutTxState(this.statement, startLabelId, typeId, endLabelId);
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(IndexDescriptor index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.counting().indexUpdatesAndSize(this.statement, index, target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(IndexDescriptor index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.counting().indexSample(this.statement, index, target);
    }

    @Override
    public void setMetaData(Map<String, Object> data) {
        this.statement.assertOpen();
        this.statement.getTransaction().setMetaData(data);
    }

    @Override
    public Map<String, Object> getMetaData() {
        this.statement.assertOpen();
        return this.statement.getTransaction().getMetaData();
    }

    @Override
    public Stream<ExecutingQuery> executingQueries() {
        this.statement.assertOpen();
        return this.queryRegistrationOperations().executingQueries(this.statement);
    }

    @Override
    public ExecutingQuery startQueryExecution(ClientConnectionInfo descriptor, String queryText, MapValue queryParameters) {
        this.statement.assertOpen();
        return this.queryRegistrationOperations().startQueryExecution(this.statement, descriptor, queryText, queryParameters);
    }

    @Override
    public void registerExecutingQuery(ExecutingQuery executingQuery) {
        this.statement.assertOpen();
        this.queryRegistrationOperations().registerExecutingQuery(this.statement, executingQuery);
    }

    @Override
    public void unregisterExecutingQuery(ExecutingQuery executingQuery) {
        this.queryRegistrationOperations().unregisterExecutingQuery(this.statement, executingQuery);
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallRead(QualifiedName name, Object[] input) throws ProcedureException {
        AccessMode accessMode = this.tx.securityContext().mode();
        if (!accessMode.allowsReads()) {
            throw accessMode.onViolation(String.format("Read operations are not allowed for %s.", this.tx.securityContext().description()));
        }
        return this.callProcedure(name, input, new RestrictedAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(QualifiedName name, Object[] input) throws ProcedureException {
        return this.callProcedure(name, input, new OverriddenAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallWrite(QualifiedName name, Object[] input) throws ProcedureException {
        AccessMode accessMode = this.tx.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.tx.securityContext().description()));
        }
        return this.callProcedure(name, input, new RestrictedAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(QualifiedName name, Object[] input) throws ProcedureException {
        return this.callProcedure(name, input, new OverriddenAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.TOKEN_WRITE));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallSchema(QualifiedName name, Object[] input) throws ProcedureException {
        AccessMode accessMode = this.tx.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.tx.securityContext().description()));
        }
        return this.callProcedure(name, input, new RestrictedAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(QualifiedName name, Object[] input) throws ProcedureException {
        return this.callProcedure(name, input, new OverriddenAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.FULL));
    }

    private RawIterator<Object[], ProcedureException> callProcedure(QualifiedName name, Object[] input, AccessMode override) throws ProcedureException {
        RawIterator<Object[], ProcedureException> procedureCall;
        this.statement.assertOpen();
        final SecurityContext procedureSecurityContext = this.tx.securityContext().withMode(override);
        try (KernelTransaction.Revertable ignore = this.tx.overrideWith(procedureSecurityContext);){
            BasicContext ctx = new BasicContext();
            ctx.put(Context.KERNEL_TRANSACTION, this.tx);
            ctx.put(Context.THREAD, Thread.currentThread());
            ctx.put(Context.SECURITY_CONTEXT, procedureSecurityContext);
            procedureCall = this.procedures.callProcedure(ctx, name, input);
        }
        return new RawIterator<Object[], ProcedureException>(){

            public boolean hasNext() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = OperationsFacade.this.tx.overrideWith(procedureSecurityContext);){
                    boolean bl = procedureCall.hasNext();
                    return bl;
                }
            }

            public Object[] next() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = OperationsFacade.this.tx.overrideWith(procedureSecurityContext);){
                    Object[] objectArray = (Object[])procedureCall.next();
                    return objectArray;
                }
            }
        };
    }

    @Override
    public Object functionCall(QualifiedName name, Object[] arguments) throws ProcedureException {
        if (!this.tx.securityContext().mode().allowsReads()) {
            throw this.tx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.tx.securityContext().description()));
        }
        return this.callFunction(name, arguments, new RestrictedAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    @Override
    public Object functionCallOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        return this.callFunction(name, arguments, new OverriddenAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    @Override
    public CallableUserAggregationFunction.Aggregator aggregationFunction(QualifiedName name) throws ProcedureException {
        if (!this.tx.securityContext().mode().allowsReads()) {
            throw this.tx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.tx.securityContext().description()));
        }
        return this.aggregationFunction(name, new RestrictedAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    @Override
    public CallableUserAggregationFunction.Aggregator aggregationFunctionOverride(QualifiedName name) throws ProcedureException {
        return this.aggregationFunction(name, new OverriddenAccessMode(this.tx.securityContext().mode(), (AccessMode)AccessMode.Static.READ));
    }

    private Object callFunction(QualifiedName name, Object[] input, AccessMode mode) throws ProcedureException {
        this.statement.assertOpen();
        try (KernelTransaction.Revertable ignore = this.tx.overrideWith(this.tx.securityContext().withMode(mode));){
            BasicContext ctx = new BasicContext();
            ctx.put(Context.KERNEL_TRANSACTION, this.tx);
            ctx.put(Context.THREAD, Thread.currentThread());
            Object object = this.procedures.callFunction(ctx, name, input);
            return object;
        }
    }

    private CallableUserAggregationFunction.Aggregator aggregationFunction(QualifiedName name, AccessMode mode) throws ProcedureException {
        this.statement.assertOpen();
        try (KernelTransaction.Revertable ignore = this.tx.overrideWith(this.tx.securityContext().withMode(mode));){
            BasicContext ctx = new BasicContext();
            ctx.put(Context.KERNEL_TRANSACTION, this.tx);
            ctx.put(Context.THREAD, Thread.currentThread());
            CallableUserAggregationFunction.Aggregator aggregator = this.procedures.createAggregationFunction(ctx, name);
            return aggregator;
        }
    }

    @Override
    public PageCursorTracer getPageCursorTracer() {
        return this.statement.getPageCursorTracer();
    }
}

