/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.api.KernelTransactionTimeoutMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.JobScheduler;

public class KernelTransactionMonitorScheduler
extends LifecycleAdapter {
    private final KernelTransactionTimeoutMonitor kernelTransactionTimeoutMonitor;
    private final JobScheduler scheduler;
    private final long checkIntervalMillis;
    private JobScheduler.JobHandle monitorJobHandle;

    public KernelTransactionMonitorScheduler(KernelTransactionTimeoutMonitor kernelTransactionTimeoutMonitor, JobScheduler scheduler, long checkIntervalMillis) {
        this.kernelTransactionTimeoutMonitor = kernelTransactionTimeoutMonitor;
        this.scheduler = scheduler;
        this.checkIntervalMillis = checkIntervalMillis;
    }

    public void start() throws Throwable {
        if (this.checkIntervalMillis > 0L) {
            this.monitorJobHandle = this.scheduler.scheduleRecurring(JobScheduler.Groups.transactionTimeoutMonitor, (Runnable)this.kernelTransactionTimeoutMonitor, this.checkIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() throws Throwable {
        if (this.monitorJobHandle != null) {
            this.monitorJobHandle.cancel(true);
        }
    }
}

