/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.neo4j.internal.kernel.api.TokenNameLookup;

public class SchemaUtil {
    public static TokenNameLookup idTokenNameLookup = new TokenNameLookup(){

        public String labelGetName(int labelId) {
            return String.format("label[%d]", labelId);
        }

        public String relationshipTypeGetName(int relationshipTypeId) {
            return String.format("relType[%d]", relationshipTypeId);
        }

        public String propertyKeyGetName(int propertyKeyId) {
            return String.format("property[%d]", propertyKeyId);
        }
    };

    private SchemaUtil() {
    }

    public static String niceProperties(TokenNameLookup tokenNameLookup, int[] propertyIds) {
        return SchemaUtil.niceProperties(tokenNameLookup, propertyIds, "", false);
    }

    public static String niceProperties(TokenNameLookup tokenNameLookup, int[] propertyIds, String prefix, boolean useBrackets) {
        StringBuilder properties = new StringBuilder();
        if (useBrackets) {
            properties.append("(");
        }
        for (int i = 0; i < propertyIds.length; ++i) {
            if (i > 0) {
                properties.append(", ");
            }
            properties.append(prefix).append(tokenNameLookup.propertyKeyGetName(propertyIds[i]));
        }
        if (useBrackets) {
            properties.append(")");
        }
        return properties.toString();
    }
}

