/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.unsafe.impl.batchimport.AssignRelationshipIdBatchStep;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.InputEntityCacherStep;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.InputIteratorBatcherStep;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipPreparationStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipRecordPreparationStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipTypeCheckerStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipTypeDistribution;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class RelationshipStage
extends Stage {
    public static final String NAME = "Relationships";
    private RelationshipTypeCheckerStep typer;

    public RelationshipStage(Configuration config, IoMonitor writeMonitor, InputIterable<InputRelationship> relationships, IdMapper idMapper, Collector badCollector, InputCache inputCache, BatchingNeoStores neoStore, EntityStoreUpdaterStep.Monitor storeUpdateMonitor) throws IOException {
        super(NAME, null, config, 1);
        this.add(new InputIteratorBatcherStep<InputRelationship>(this.control(), config, (InputIterator<InputRelationship>)relationships.iterator(), InputRelationship.class, r -> true));
        if (!relationships.supportsMultiplePasses()) {
            this.add(new InputEntityCacherStep(this.control(), config, inputCache.cacheRelationships("main")));
        }
        RelationshipStore relationshipStore = neoStore.getRelationshipStore();
        PropertyStore propertyStore = neoStore.getPropertyStore();
        this.typer = new RelationshipTypeCheckerStep(this.control(), config, neoStore.getRelationshipTypeRepository());
        this.add(this.typer);
        this.add(new AssignRelationshipIdBatchStep(this.control(), config, 0L));
        this.add(new RelationshipPreparationStep(this.control(), config, idMapper));
        this.add(new RelationshipRecordPreparationStep(this.control(), config, neoStore.getRelationshipTypeRepository(), badCollector));
        this.add(new PropertyEncoderStep(this.control(), config, neoStore.getPropertyKeyRepository(), propertyStore));
        this.add(new EntityStoreUpdaterStep(this.control(), config, relationshipStore, propertyStore, writeMonitor, storeUpdateMonitor));
    }

    public RelationshipTypeDistribution getDistribution() {
        return this.typer.getDistribution();
    }
}

