/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.References;
import org.neo4j.kernel.impl.newapi.RelationshipTraversalCursor;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class RelationshipGroupCursor
extends RelationshipGroupRecord
implements org.neo4j.internal.kernel.api.RelationshipGroupCursor {
    private Read read;
    private final RelationshipRecord edge = new RelationshipRecord(-1L);
    private Group current;
    private PageCursor page;
    private PageCursor edgePage;

    RelationshipGroupCursor() {
        super(-1L);
    }

    void buffer(long nodeReference, long relationshipReference, Read read) {
        this.setOwningNode(nodeReference);
        this.setId(-1L);
        this.setNext(-1L);
        try (PrimitiveIntObjectMap buffer = Primitive.intObjectMap();
             PageCursor edgePage = read.relationshipPage(relationshipReference);){
            Group current = null;
            while (relationshipReference != -1L) {
                read.relationship(this.edge, relationshipReference, edgePage);
                Group group = (Group)buffer.get(this.edge.getType());
                if (group == null) {
                    current = group = new Group(this.edge, current);
                    buffer.put(this.edge.getType(), (Object)group);
                }
                if (this.edge.getFirstNode() == nodeReference) {
                    if (this.edge.getSecondNode() == nodeReference) {
                        group.loop(this.edge);
                    } else {
                        group.outgoing(this.edge);
                    }
                    relationshipReference = this.edge.getFirstNextRel();
                    continue;
                }
                if (this.edge.getSecondNode() == nodeReference) {
                    group.incoming(this.edge);
                    relationshipReference = this.edge.getSecondNextRel();
                    continue;
                }
                throw new IllegalStateException("not a part of the chain! TODO: better exception");
            }
            this.current = new Group(this.edge, current);
            this.read = read;
        }
    }

    void direct(long nodeReference, long reference, Read read) {
        this.setOwningNode(nodeReference);
        this.current = null;
        this.clear();
        this.setNext(reference);
        if (this.page == null) {
            this.page = read.groupPage(reference);
        }
        this.read = read;
    }

    public RelationshipGroupCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipGroupCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean next() {
        if (this.current != null) {
            this.current = this.current.next;
            if (this.current == null) {
                return false;
            }
            this.setType(this.current.label);
            this.setFirstOut(this.current.outgoing());
            this.setFirstIn(this.current.incoming());
            this.setFirstLoop(this.current.loops());
            return true;
        }
        if (this.getNext() == -1L) {
            return false;
        }
        this.read.group(this, this.getNext(), this.page);
        return true;
    }

    public boolean shouldRetry() {
        return false;
    }

    public void close() {
        if (this.page != null) {
            this.page.close();
            this.page = null;
        }
        if (this.edgePage != null) {
            this.edgePage.close();
            this.edgePage = null;
        }
        this.current = null;
        this.read = null;
        this.setId(-1L);
        this.clear();
    }

    public int relationshipLabel() {
        return this.getType();
    }

    public int outgoingCount() {
        if (this.current != null) {
            return this.current.outgoingCount;
        }
        return this.count(this.outgoingReference());
    }

    public int incomingCount() {
        if (this.current != null) {
            return this.current.incomingCount;
        }
        return this.count(this.incomingReference());
    }

    public int loopCount() {
        if (this.current != null) {
            return this.current.loopsCount;
        }
        return this.count(this.loopsReference());
    }

    private int count(long reference) {
        if (reference == -1L) {
            return 0;
        }
        if (this.edgePage == null) {
            this.edgePage = this.read.relationshipPage(reference);
        }
        this.read.relationship(this.edge, reference, this.edgePage);
        if (this.edge.getFirstNode() == this.getOwningNode()) {
            return (int)this.edge.getFirstPrevRel();
        }
        return (int)this.edge.getSecondPrevRel();
    }

    public void outgoing(org.neo4j.internal.kernel.api.RelationshipTraversalCursor cursor) {
        if (this.current != null && cursor instanceof RelationshipTraversalCursor) {
            ((RelationshipTraversalCursor)cursor).buffered(this.getOwningNode(), this.current.outgoing, this.read);
        } else {
            this.read.relationships(this.getOwningNode(), this.outgoingReference(), cursor);
        }
    }

    public void incoming(org.neo4j.internal.kernel.api.RelationshipTraversalCursor cursor) {
        if (this.current != null && cursor instanceof RelationshipTraversalCursor) {
            ((RelationshipTraversalCursor)cursor).buffered(this.getOwningNode(), this.current.incoming, this.read);
        } else {
            this.read.relationships(this.getOwningNode(), this.incomingReference(), cursor);
        }
    }

    public void loops(org.neo4j.internal.kernel.api.RelationshipTraversalCursor cursor) {
        if (this.current != null && cursor instanceof RelationshipTraversalCursor) {
            ((RelationshipTraversalCursor)cursor).buffered(this.getOwningNode(), this.current.loops, this.read);
        } else {
            this.read.relationships(this.getOwningNode(), this.loopsReference(), cursor);
        }
    }

    public long outgoingReference() {
        return this.getFirstOut();
    }

    public long incomingReference() {
        return this.getFirstIn();
    }

    public long loopsReference() {
        return this.getFirstLoop();
    }

    public boolean isClosed() {
        return this.page == null;
    }

    static class Group {
        final int label;
        final Group next;
        RelationshipTraversalCursor.Record outgoing;
        RelationshipTraversalCursor.Record incoming;
        RelationshipTraversalCursor.Record loops;
        private long firstOut = -1L;
        private long firstIn = -1L;
        private long firstLoop = -1L;
        int outgoingCount;
        int incomingCount;
        int loopsCount;

        Group(RelationshipRecord edge, Group next) {
            this.label = edge.getType();
            this.next = next;
        }

        void outgoing(RelationshipRecord edge) {
            if (this.outgoing == null) {
                this.firstOut = edge.getId();
            }
            this.outgoing = new RelationshipTraversalCursor.Record(edge, this.outgoing);
            ++this.outgoingCount;
        }

        void incoming(RelationshipRecord edge) {
            if (this.incoming == null) {
                this.firstIn = edge.getId();
            }
            this.incoming = new RelationshipTraversalCursor.Record(edge, this.incoming);
            ++this.incomingCount;
        }

        void loop(RelationshipRecord edge) {
            if (this.loops == null) {
                this.firstLoop = edge.getId();
            }
            this.loops = new RelationshipTraversalCursor.Record(edge, this.loops);
            ++this.loopsCount;
        }

        long outgoing() {
            return References.setFilterFlag(this.firstOut);
        }

        long incoming() {
            return References.setFilterFlag(this.firstIn);
        }

        long loops() {
            return References.setFilterFlag(this.firstLoop);
        }
    }
}

