/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Map;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeExplicitIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.NodeCursor;
import org.neo4j.kernel.impl.newapi.PropertyCursor;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Operations
implements Read,
ExplicitIndexRead,
SchemaRead,
Write,
ExplicitIndexWrite {
    private final KernelTransactionImplementation ktx;
    private final AllStoreHolder allStoreHolder;
    private final StorageStatement statement;
    private final AutoIndexing autoIndexing;
    private NodeCursor nodeCursor;
    private final IndexTxStateUpdater updater;
    private PropertyCursor propertyCursor;
    private final Cursors cursors;

    public Operations(AllStoreHolder allStoreHolder, IndexTxStateUpdater updater, StorageStatement statement, KernelTransactionImplementation ktx, Cursors cursors, AutoIndexing autoIndexing) {
        this.autoIndexing = autoIndexing;
        this.allStoreHolder = allStoreHolder;
        this.ktx = ktx;
        this.statement = statement;
        this.updater = updater;
        this.cursors = cursors;
    }

    public void initialize() {
        this.nodeCursor = this.cursors.allocateNodeCursor();
        this.propertyCursor = this.cursors.allocatePropertyCursor();
    }

    public void nodeIndexSeek(IndexReference index, NodeValueIndexCursor cursor, IndexOrder order, IndexQuery ... query) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeIndexSeek(index, cursor, order, query);
    }

    public void nodeIndexScan(IndexReference index, NodeValueIndexCursor cursor, IndexOrder order) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeIndexScan(index, cursor, order);
    }

    public void nodeLabelScan(int label, NodeLabelIndexCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.nodeLabelScan(label, cursor);
    }

    public void nodeLabelUnionScan(NodeLabelIndexCursor cursor, int ... labels) {
        this.assertOpen();
        this.allStoreHolder.nodeLabelUnionScan(cursor, labels);
    }

    public void nodeLabelIntersectionScan(NodeLabelIndexCursor cursor, int ... labels) {
        this.assertOpen();
        this.allStoreHolder.nodeLabelIntersectionScan(cursor, labels);
    }

    public Scan<NodeLabelIndexCursor> nodeLabelScan(int label) {
        this.assertOpen();
        return this.allStoreHolder.nodeLabelScan(label);
    }

    public void allNodesScan(org.neo4j.internal.kernel.api.NodeCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.allNodesScan(cursor);
    }

    public Scan<org.neo4j.internal.kernel.api.NodeCursor> allNodesScan() {
        this.assertOpen();
        return this.allStoreHolder.allNodesScan();
    }

    public void singleNode(long reference, org.neo4j.internal.kernel.api.NodeCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.singleNode(reference, cursor);
    }

    public void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.singleRelationship(reference, cursor);
    }

    public void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.allRelationshipsScan(cursor);
    }

    public Scan<RelationshipScanCursor> allRelationshipsScan() {
        this.assertOpen();
        return this.allStoreHolder.allRelationshipsScan();
    }

    public void relationshipLabelScan(int label, RelationshipScanCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.relationshipLabelScan(label, cursor);
    }

    public Scan<RelationshipScanCursor> relationshipLabelScan(int label) {
        this.assertOpen();
        return this.allStoreHolder.relationshipLabelScan(label);
    }

    public void relationshipGroups(long nodeReference, long reference, RelationshipGroupCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.relationshipGroups(nodeReference, reference, cursor);
    }

    public void relationships(long nodeReference, long reference, RelationshipTraversalCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.relationships(nodeReference, reference, cursor);
    }

    public void nodeProperties(long reference, org.neo4j.internal.kernel.api.PropertyCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.nodeProperties(reference, cursor);
    }

    public void relationshipProperties(long reference, org.neo4j.internal.kernel.api.PropertyCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.relationshipProperties(reference, cursor);
    }

    public void graphProperties(org.neo4j.internal.kernel.api.PropertyCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.graphProperties(cursor);
    }

    public void futureNodeReferenceRead(long reference) {
        this.assertOpen();
        this.allStoreHolder.futureNodeReferenceRead(reference);
    }

    public void futureRelationshipsReferenceRead(long reference) {
        this.assertOpen();
        this.allStoreHolder.futureRelationshipsReferenceRead(reference);
    }

    public void futureNodePropertyReferenceRead(long reference) {
        this.assertOpen();
        this.allStoreHolder.futureNodePropertyReferenceRead(reference);
    }

    public void futureRelationshipPropertyReferenceRead(long reference) {
        this.assertOpen();
        this.allStoreHolder.futureRelationshipPropertyReferenceRead(reference);
    }

    public void nodeExplicitIndexLookup(NodeExplicitIndexCursor cursor, String index, String key, Value value) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeExplicitIndexLookup(cursor, index, key, value);
    }

    public void nodeExplicitIndexQuery(NodeExplicitIndexCursor cursor, String index, Object query) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeExplicitIndexQuery(cursor, index, query);
    }

    public void nodeExplicitIndexQuery(NodeExplicitIndexCursor cursor, String index, String key, Object query) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeExplicitIndexQuery(cursor, index, key, query);
    }

    public void relationshipExplicitIndexGet(RelationshipExplicitIndexCursor cursor, String index, String key, Value value, long source, long target) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.relationshipExplicitIndexGet(cursor, index, key, value, source, target);
    }

    public void relationshipExplicitIndexQuery(RelationshipExplicitIndexCursor cursor, String index, Object query, long source, long target) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.relationshipExplicitIndexQuery(cursor, index, query, source, target);
    }

    public void relationshipExplicitIndexQuery(RelationshipExplicitIndexCursor cursor, String index, String key, Object query, long source, long target) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.relationshipExplicitIndexQuery(cursor, index, key, query, source, target);
    }

    public CapableIndexReference index(int label, int ... properties) {
        this.assertOpen();
        return this.allStoreHolder.index(label, properties);
    }

    private void assertOpen() {
        if (this.ktx.isTerminated()) {
            Status terminationReason = this.ktx.getReasonIfTerminated().orElse((Status)Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
    }

    public long nodeCreate() {
        this.assertOpen();
        long nodeId = this.statement.reserveNode();
        this.ktx.txState().nodeDoCreate(nodeId);
        return nodeId;
    }

    public boolean nodeDelete(long node) throws AutoIndexingKernelException {
        this.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            if (this.ktx.txState().nodeIsAddedInThisTx(node)) {
                this.autoIndexing.nodes().entityRemoved(this, node);
                this.ktx.txState().nodeDoDelete(node);
                return true;
            }
            if (this.ktx.txState().nodeIsDeletedInThisTx(node)) {
                return false;
            }
        }
        this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        if (this.allStoreHolder.nodeExistsInStore(node)) {
            this.autoIndexing.nodes().entityRemoved(this, node);
            this.ktx.txState().nodeDoDelete(node);
            return true;
        }
        return false;
    }

    public long relationshipCreate(long sourceNode, int relationshipLabel, long targetNode) {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    public void relationshipDelete(long relationship) {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    public boolean nodeAddLabel(long node, int nodeLabel) throws EntityNotFoundException {
        this.acquireSharedLabelLock(nodeLabel);
        this.acquireExclusiveNodeLock(node);
        this.assertOpen();
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
        if (this.nodeCursor.labels().contains(nodeLabel)) {
            return false;
        }
        this.ktx.txState().nodeDoAddLabel(nodeLabel, node);
        this.updater.onLabelChange(nodeLabel, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        return true;
    }

    public boolean nodeRemoveLabel(long node, int nodeLabel) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.assertOpen();
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
        if (!this.nodeCursor.labels().contains(nodeLabel)) {
            return false;
        }
        this.ktx.txState().nodeDoRemoveLabel(nodeLabel, node);
        this.updater.onLabelChange(nodeLabel, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        return true;
    }

    public Value nodeSetProperty(long node, int propertyKey, Value value) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveNodeLock(node);
        this.assertOpen();
        Value existingValue = this.readNodeProperty(node, propertyKey);
        if (existingValue == Values.NO_VALUE) {
            this.autoIndexing.nodes().propertyAdded(this, node, propertyKey, value);
            this.ktx.txState().nodeDoAddProperty(node, propertyKey, value);
            this.updater.onPropertyAdd(this.nodeCursor, this.propertyCursor, propertyKey, value);
            return Values.NO_VALUE;
        }
        if (!value.equals(existingValue)) {
            this.autoIndexing.nodes().propertyChanged(this, node, propertyKey, existingValue, value);
            this.ktx.txState().nodeDoChangeProperty(node, propertyKey, existingValue, value);
            this.updater.onPropertyChange(this.nodeCursor, this.propertyCursor, propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value nodeRemoveProperty(long node, int propertyKey) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveNodeLock(node);
        this.assertOpen();
        Value existingValue = this.readNodeProperty(node, propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.autoIndexing.nodes().propertyRemoved(this, node, propertyKey);
            this.ktx.txState().nodeDoRemoveProperty(node, propertyKey, existingValue);
            this.updater.onPropertyRemove(this.nodeCursor, this.propertyCursor, propertyKey, existingValue);
        }
        return existingValue;
    }

    public Value relationshipSetProperty(long relationship, int propertyKey, Value value) {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    public Value relationshipRemoveProperty(long node, int propertyKey) {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    public Value graphSetProperty(int propertyKey, Value value) {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    public Value graphRemoveProperty(int propertyKey) {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    public void nodeAddToExplicitIndex(String indexName, long node, String key, Object value) throws EntityNotFoundException, ExplicitIndexNotFoundKernelException {
        this.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).addNode(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node) throws ExplicitIndexNotFoundKernelException {
        this.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).remove(node);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).remove(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key) throws ExplicitIndexNotFoundKernelException {
        this.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).remove(node, key);
    }

    public void nodeExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.assertOpen();
        this.ktx.explicitIndexTxState().createIndex(IndexEntityType.Node, indexName, customConfig);
    }

    public void nodeExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.assertOpen();
        this.allStoreHolder.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    public void relationshipAddToExplicitIndex(String indexName, long relationship, String key, Object value) throws EntityNotFoundException, ExplicitIndexNotFoundKernelException {
        throw new UnsupportedOperationException();
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key, Object value) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.assertOpen();
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key, value);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).remove(relationship);
    }

    public void relationshipExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.assertOpen();
        this.ktx.explicitIndexTxState().createIndex(IndexEntityType.Relationship, indexName, customConfig);
    }

    public void relationshipExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.assertOpen();
        this.allStoreHolder.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    private Value readNodeProperty(long node, int propertyKey) throws EntityNotFoundException {
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
        this.nodeCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
    }

    public Token token() {
        return this.allStoreHolder;
    }

    private void acquireExclusiveNodeLock(long node) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().nodeIsAddedInThisTx(node)) {
            this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        }
    }

    private void acquireSharedLabelLock(int labelId) {
        this.ktx.locks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.LABEL, labelId);
    }
}

