/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.References;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.storageengine.api.txstate.NodeState;

class NodeCursor
extends NodeRecord
implements org.neo4j.internal.kernel.api.NodeCursor {
    private Read read;
    private RecordCursor<DynamicRecord> labelCursor;
    private PageCursor pageCursor;
    private long next;
    private long highMark;

    NodeCursor() {
        super(-1L);
    }

    void scan(Read read) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = read.nodePage(0L);
        }
        this.next = 0L;
        this.highMark = read.nodeHighMark();
        this.read = read;
        if (this.labelCursor == null) {
            this.labelCursor = read.labelCursor();
        }
    }

    void single(long reference, Read read) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = read.nodePage(reference);
        }
        this.next = reference;
        this.highMark = -1L;
        this.read = read;
        if (this.labelCursor == null) {
            this.labelCursor = read.labelCursor();
        }
    }

    public long nodeReference() {
        return this.getId();
    }

    public LabelSet labels() {
        if (this.read.hasTxStateWithChanges()) {
            TransactionState txState = this.read.txState();
            if (txState.nodeIsAddedInThisTx(this.nodeReference())) {
                return Labels.from(txState.nodeStateLabelDiffSets(this.nodeReference()).getAdded());
            }
            long[] longs = NodeLabelsField.get((NodeRecord)this, this.labelCursor);
            PrimitiveIntSet labels = Primitive.intSet();
            for (long labelToken : longs) {
                labels.add((int)labelToken);
            }
            return Labels.from(txState.augmentLabels(labels, txState.getNodeState(this.nodeReference())));
        }
        return new Labels(NodeLabelsField.get((NodeRecord)this, this.labelCursor));
    }

    public boolean hasProperties() {
        return this.nextProp != -1L;
    }

    public void relationships(RelationshipGroupCursor cursor) {
        this.read.relationshipGroups(this.nodeReference(), this.relationshipGroupReference(), cursor);
    }

    public void allRelationships(RelationshipTraversalCursor cursor) {
        this.read.relationships(this.nodeReference(), this.allRelationshipsReference(), cursor);
    }

    public void properties(PropertyCursor cursor) {
        this.read.nodeProperties(this.propertiesReference(), cursor);
    }

    public long relationshipGroupReference() {
        return this.isDense() ? this.getNextRel() : References.setDirectFlag(this.getNextRel());
    }

    public long allRelationshipsReference() {
        return this.isDense() ? References.setGroupFlag(this.getNextRel()) : this.getNextRel();
    }

    public long propertiesReference() {
        TransactionState txState;
        NodeState nodeState;
        long propertiesReference = this.getNextProp();
        if (this.read.hasTxStateWithChanges() && (nodeState = (txState = this.read.txState()).getNodeState(this.nodeReference())).hasPropertyChanges()) {
            long ref;
            if (propertiesReference == -1L) {
                ref = References.setNodeFlag(this.nodeReference());
            } else {
                ref = References.setTxStateFlag(propertiesReference);
                txState.registerProperties(ref, nodeState);
            }
            return ref;
        }
        return propertiesReference;
    }

    public boolean next() {
        TransactionState txs;
        if (this.next == -1L) {
            this.reset();
            return false;
        }
        boolean hasChanges = this.read.hasTxStateWithChanges();
        TransactionState transactionState = txs = hasChanges ? this.read.txState() : null;
        do {
            if (hasChanges && txs.nodeIsAddedInThisTx(this.next)) {
                this.setId(this.next++);
                this.setInUse(true);
            } else if (hasChanges && txs.nodeIsDeletedInThisTx(this.next)) {
                ++this.next;
                this.setInUse(false);
            } else {
                this.read.node(this, this.next++, this.pageCursor);
            }
            if (this.next > this.highMark) {
                if (this.isSingle()) {
                    this.next = -1L;
                    return this.inUse();
                }
                this.highMark = this.read.nodeHighMark();
                if (this.next <= this.highMark) continue;
                this.next = -1L;
                return this.inUse();
            }
            if (this.next >= 0L) continue;
            this.next = -1L;
            return this.inUse();
        } while (!this.inUse());
        return true;
    }

    public boolean shouldRetry() {
        return false;
    }

    public void close() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
        this.read = null;
        if (this.labelCursor != null) {
            this.labelCursor.close();
            this.labelCursor = null;
        }
        this.reset();
    }

    public boolean isClosed() {
        return this.pageCursor == null;
    }

    private void reset() {
        this.next = -1L;
        this.setId(-1L);
    }

    private boolean isSingle() {
        return this.highMark == -1L;
    }
}

