/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.nio.ByteBuffer;
import java.util.Map;
import org.neo4j.function.Suppliers;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.store.PropertyUtil;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.kernel.impl.newapi.DefaultCapableIndexReference;
import org.neo4j.kernel.impl.newapi.PropertyCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public class AllStoreHolder
extends Read
implements Token {
    private final StorageStatement.Nodes nodes;
    private final StorageStatement.Groups groups;
    private final StorageStatement.Properties properties;
    private final StorageStatement.Relationships relationships;
    private final StorageStatement statement;
    private final StoreReadLayer storeReadLayer;
    private final ExplicitIndexStore explicitIndexStore;
    private final Suppliers.Lazy<ExplicitIndexTransactionState> explicitIndexes;

    public AllStoreHolder(StorageEngine engine, StorageStatement statement, TxStateHolder txStateHolder, Cursors cursors, ExplicitIndexStore explicitIndexStore, AssertOpen assertOpen) {
        super(cursors, txStateHolder, assertOpen);
        this.storeReadLayer = engine.storeReadLayer();
        this.statement = statement;
        this.explicitIndexes = Suppliers.lazySingleton(txStateHolder::explicitIndexTxState);
        this.nodes = statement.nodes();
        this.relationships = statement.relationships();
        this.groups = statement.groups();
        this.properties = statement.properties();
        this.explicitIndexStore = explicitIndexStore;
    }

    @Override
    long graphPropertiesReference() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    IndexReader indexReader(IndexReference index) {
        try {
            IndexDescriptor indexDescriptor = index.isUnique() ? IndexDescriptorFactory.uniqueForLabel(index.label(), index.properties()) : IndexDescriptorFactory.forLabel(index.label(), index.properties());
            return this.statement.getIndexReader(indexDescriptor);
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
    }

    @Override
    LabelScanReader labelScanReader() {
        return this.statement.getLabelScanReader();
    }

    @Override
    ExplicitIndex explicitNodeIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        return ((ExplicitIndexTransactionState)this.explicitIndexes.get()).nodeChanges(indexName);
    }

    @Override
    ExplicitIndex explicitRelationshipIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        return ((ExplicitIndexTransactionState)this.explicitIndexes.get()).relationshipChanges(indexName);
    }

    @Override
    public CapableIndexReference index(int label, int ... properties) {
        IndexDescriptor indexDescriptor = this.storeReadLayer.indexGetForSchema(new LabelSchemaDescriptor(label, properties));
        if (indexDescriptor == null) {
            return CapableIndexReference.NO_INDEX;
        }
        boolean unique = indexDescriptor.type() == IndexDescriptor.Type.UNIQUE;
        try {
            IndexCapability indexCapability = this.storeReadLayer.indexGetCapability(indexDescriptor);
            return new DefaultCapableIndexReference(unique, indexCapability, label, properties);
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException("Could not find capability for index " + indexDescriptor, (Throwable)((Object)e));
        }
    }

    public int labelGetOrCreateForName(String labelName) throws KernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws KernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws KernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void labelCreateForName(String labelName, int id) throws KernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void propertyKeyCreateForName(String propertyKeyName, int id) throws KernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void relationshipTypeCreateForName(String relationshipTypeName, int id) throws KernelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public int nodeLabel(String name) {
        return this.storeReadLayer.labelGetForName(name);
    }

    public int relationshipType(String name) {
        return this.storeReadLayer.relationshipTypeGetForName(name);
    }

    public int propertyKey(String name) {
        return this.storeReadLayer.propertyKeyGetForName(name);
    }

    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.storeReadLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    PageCursor nodePage(long reference) {
        return this.nodes.openPageCursor(reference);
    }

    @Override
    PageCursor relationshipPage(long reference) {
        return this.relationships.openPageCursor(reference);
    }

    @Override
    PageCursor groupPage(long reference) {
        return this.groups.openPageCursor(reference);
    }

    @Override
    PageCursor propertyPage(long reference) {
        return this.properties.openPageCursor(reference);
    }

    @Override
    PageCursor stringPage(long reference) {
        return this.properties.openStringPageCursor(reference);
    }

    @Override
    PageCursor arrayPage(long reference) {
        return this.properties.openArrayPageCursor(reference);
    }

    @Override
    RecordCursor<DynamicRecord> labelCursor() {
        return this.nodes.newLabelCursor();
    }

    @Override
    void node(NodeRecord record, long reference, PageCursor pageCursor) {
        this.nodes.loadRecordByCursor(reference, record, RecordLoad.CHECK, pageCursor);
    }

    @Override
    void relationship(RelationshipRecord record, long reference, PageCursor pageCursor) {
        this.relationships.loadRecordByCursor(reference, record, RecordLoad.CHECK, pageCursor);
    }

    @Override
    void property(PropertyRecord record, long reference, PageCursor pageCursor) {
        this.properties.loadRecordByCursor(reference, record, RecordLoad.FORCE, pageCursor);
    }

    @Override
    void group(RelationshipGroupRecord record, long reference, PageCursor page) {
        this.groups.loadRecordByCursor(reference, record, RecordLoad.NORMAL, page);
    }

    @Override
    long nodeHighMark() {
        return this.nodes.getHighestPossibleIdInUse();
    }

    @Override
    long relationshipHighMark() {
        return this.relationships.getHighestPossibleIdInUse();
    }

    @Override
    TextValue string(PropertyCursor cursor, long reference, PageCursor page) {
        ByteBuffer buffer = cursor.buffer = this.properties.loadString(reference, cursor.buffer, page);
        buffer.flip();
        return Values.stringValue((String)UTF8.decode((byte[])buffer.array(), (int)0, (int)buffer.limit()));
    }

    @Override
    ArrayValue array(PropertyCursor cursor, long reference, PageCursor page) {
        ByteBuffer buffer = cursor.buffer = this.properties.loadArray(reference, cursor.buffer, page);
        buffer.flip();
        return PropertyUtil.readArrayFromBuffer(buffer);
    }

    public boolean nodeExistsInStore(long id) {
        return this.storeReadLayer.nodeExists(id);
    }

    void getOrCreateNodeIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    void getOrCreateRelationshipIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }
}

