/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

public class NumberHitIndexProgressor<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
implements IndexProgressor {
    private final RawCursor<Hit<KEY, VALUE>, IOException> seeker;
    private final IndexProgressor.NodeValueClient client;
    private final Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose;
    private boolean closed;

    NumberHitIndexProgressor(RawCursor<Hit<KEY, VALUE>, IOException> seeker, IndexProgressor.NodeValueClient client, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose) {
        this.seeker = seeker;
        this.client = client;
        this.toRemoveFromOnClose = toRemoveFromOnClose;
    }

    @Override
    public boolean next() {
        try {
            if (this.seeker.next()) {
                SchemaNumberKey key = (SchemaNumberKey)((Object)((Hit)this.seeker.get()).key());
                this.client.acceptNode(key.entityId, new Value[]{key.asValue()});
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.seeker.close();
                this.toRemoveFromOnClose.remove(this.seeker);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

