/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.impl.core.RelationshipConversion;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Values;

public class NodeProxy
implements Node {
    private final NodeActions actions;
    private final long nodeId;

    public NodeProxy(NodeActions actions, long nodeId) {
        this.nodeId = nodeId;
        this.actions = actions;
    }

    public long getId() {
        return this.nodeId;
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.actions.getGraphDatabase();
    }

    public void delete() {
        try (Statement ignore = this.actions.statement();){
            boolean deleted = this.actions.kernelTransaction().dataWrite().nodeDelete(this.getId());
            if (!deleted) {
                throw new NotFoundException("Unable to delete Node[" + this.nodeId + "] since it has already been deleted.");
            }
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while deleting the node: " + e.getMessage(), e);
        }
    }

    public ResourceIterable<Relationship> getRelationships() {
        return this.getRelationships(Direction.BOTH);
    }

    public ResourceIterable<Relationship> getRelationships(Direction dir) {
        this.assertInUnterminatedTransaction();
        return () -> {
            Statement statement = this.actions.statement();
            try {
                RelationshipConversion result = new RelationshipConversion(this.actions);
                result.iterator = statement.readOperations().nodeGetRelationships(this.nodeId, dir);
                result.statement = statement;
                return result;
            }
            catch (EntityNotFoundException e) {
                statement.close();
                throw new NotFoundException(String.format("Node %d not found", this.nodeId), (Throwable)((Object)e));
            }
            catch (Throwable e) {
                statement.close();
                throw e;
            }
        };
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.getRelationships(Direction.BOTH, types);
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.getRelationships(dir, type);
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        int[] typeIds;
        try (Statement statement = this.actions.statement();){
            typeIds = this.relTypeIds(types, statement);
        }
        return () -> {
            Statement statement = this.actions.statement();
            try {
                RelationshipConversion result = new RelationshipConversion(this.actions);
                result.iterator = statement.readOperations().nodeGetRelationships(this.nodeId, direction, typeIds);
                result.statement = statement;
                return result;
            }
            catch (EntityNotFoundException e) {
                statement.close();
                throw new NotFoundException(String.format("Node %d not found", this.nodeId), (Throwable)((Object)e));
            }
            catch (Throwable e) {
                statement.close();
                throw e;
            }
        };
    }

    public boolean hasRelationship() {
        return this.hasRelationship(Direction.BOTH);
    }

    public boolean hasRelationship(Direction dir) {
        try (ResourceIterator rels = this.getRelationships(dir).iterator();){
            boolean bl = rels.hasNext();
            return bl;
        }
    }

    public boolean hasRelationship(RelationshipType ... types) {
        return this.hasRelationship(Direction.BOTH, types);
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        try (ResourceIterator rels = this.getRelationships(direction, types).iterator();){
            boolean bl = rels.hasNext();
            return bl;
        }
    }

    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.hasRelationship(dir, type);
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        try (ResourceIterator rels = this.getRelationships(dir, type).iterator();){
            if (!rels.hasNext()) {
                Relationship relationship = null;
                return relationship;
            }
            Relationship rel = (Relationship)rels.next();
            while (rels.hasNext()) {
                Relationship other = (Relationship)rels.next();
                if (other.equals(rel)) continue;
                throw new NotFoundException("More than one relationship[" + type + ", " + dir + "] found for " + this);
            }
            Relationship relationship = rel;
            return relationship;
        }
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInUnterminatedTransaction();
    }

    public void setProperty(String key, Object value) {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            try {
                statement.dataWriteOperations().nodeSetProperty(this.nodeId, propertyKeyId, Values.of((Object)value, (boolean)false));
            }
            catch (ConstraintValidationException e) {
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)((Object)e));
            }
            catch (IllegalArgumentException e) {
                this.actions.failTransaction();
                throw e;
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)((Object)e));
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), (Throwable)((Object)e));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while setting property: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object removeProperty(String key) throws NotFoundException {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().nodeRemoveProperty(this.nodeId, propertyKeyId).asObjectCopy();
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)((Object)e));
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), (Throwable)((Object)e));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while removing property: " + e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    public Object getProperty(String key, Object defaultValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Iterable<String> getPropertyKeys() {
        KernelTransaction transaction = this.actions.kernelTransaction();
        CursorFactory cursors = transaction.cursors();
        ArrayList<String> keys = new ArrayList<String>();
        try (NodeCursor nodes = cursors.allocateNodeCursor();
             PropertyCursor properties = cursors.allocatePropertyCursor();
             Statement ignore = this.actions.statement();){
            transaction.dataRead().singleNode(this.nodeId, nodes);
            Token token = transaction.token();
            if (!nodes.next()) {
                throw new NotFoundException((Throwable)((Object)new EntityNotFoundException(EntityType.NODE, this.nodeId)));
            }
            nodes.properties(properties);
            while (properties.next()) {
                keys.add(token.propertyKeyGetName(properties.propertyKey()));
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return keys;
    }

    public Map<String, Object> getProperties(String ... keys) {
        Objects.requireNonNull(keys, "Properties keys should be not null array.");
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        try (Statement ignore = this.actions.statement();){
            KernelTransaction transaction = this.actions.kernelTransaction();
            CursorFactory cursors = transaction.cursors();
            int itemsToReturn = keys.length;
            HashMap<String, Object> properties = new HashMap<String, Object>(itemsToReturn);
            Token token = transaction.token();
            int[] propertyIds = new int[itemsToReturn];
            for (int i = 0; i < itemsToReturn; ++i) {
                String key = keys[i];
                if (key == null) {
                    throw new NullPointerException(String.format("Key %d was null", i));
                }
                propertyIds[i] = token.propertyKey(key);
            }
            try (NodeCursor nodes = cursors.allocateNodeCursor();
                 PropertyCursor propertyCursor = cursors.allocatePropertyCursor();){
                transaction.dataRead().singleNode(this.nodeId, nodes);
                if (!nodes.next()) {
                    throw new NotFoundException((Throwable)((Object)new EntityNotFoundException(EntityType.NODE, this.nodeId)));
                }
                nodes.properties(propertyCursor);
                while (propertyCursor.next()) {
                    for (int propertyId : propertyIds) {
                        int currentKey = propertyCursor.propertyKey();
                        if (propertyId != currentKey) continue;
                        properties.put(token.propertyKeyGetName(currentKey), propertyCursor.propertyValue().asObjectCopy());
                    }
                }
            }
            catch (PropertyKeyIdNotFoundKernelException e) {
                throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
            }
            HashMap<String, Object> hashMap = properties;
            return hashMap;
        }
    }

    public Map<String, Object> getAllProperties() {
        KernelTransaction transaction = this.actions.kernelTransaction();
        CursorFactory cursors = transaction.cursors();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try (Statement ignore = this.actions.statement();
             NodeCursor nodes = cursors.allocateNodeCursor();
             PropertyCursor propertyCursor = cursors.allocatePropertyCursor();){
            Token token = transaction.token();
            transaction.dataRead().singleNode(this.nodeId, nodes);
            if (!nodes.next()) {
                throw new NotFoundException((Throwable)((Object)new EntityNotFoundException(EntityType.NODE, this.nodeId)));
            }
            nodes.properties(propertyCursor);
            while (propertyCursor.next()) {
                properties.put(token.propertyKeyGetName(propertyCursor.propertyKey()), propertyCursor.propertyValue().asObjectCopy());
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return properties;
    }

    /*
     * Exception decompiling
     */
    public Object getProperty(String key) throws NotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 28[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean hasProperty(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 47[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        if (otherNode == null) {
            throw new IllegalArgumentException("Other node is null.");
        }
        try (Statement statement = this.actions.statement();){
            int relationshipTypeId = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName(type.name());
            long relationshipId = statement.dataWriteOperations().relationshipCreate(relationshipTypeId, this.nodeId, otherNode.getId());
            Relationship relationship = this.actions.newRelationshipProxy(relationshipId, this.nodeId, relationshipTypeId, otherNode.getId());
            return relationship;
        }
        catch (RelationshipTypeIdNotFoundKernelException | IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node[" + e.entityId() + "] is deleted and cannot be used to create a relationship");
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public void addLabel(Label label) {
        try (Statement statement = this.actions.statement();){
            try {
                statement.dataWriteOperations().nodeAddLabel(this.getId(), statement.tokenWriteOperations().labelGetOrCreateForName(label.name()));
            }
            catch (ConstraintValidationException e) {
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)((Object)e));
            }
        }
        catch (IllegalTokenNameException e) {
            throw new ConstraintViolationException(String.format("Invalid label name '%s'.", label.name()), (Throwable)((Object)e));
        }
        catch (TooManyLabelsException e) {
            throw new ConstraintViolationException("Unable to add label.", (Throwable)((Object)e));
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", (Throwable)((Object)e));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeLabel(Label label) {
        try (Statement statement = this.actions.statement();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId != -1) {
                statement.dataWriteOperations().nodeRemoveLabel(this.getId(), labelId);
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", (Throwable)((Object)e));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasLabel(Label label) {
        try (Statement statement = this.actions.statement();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            boolean bl = statement.readOperations().nodeHasLabel(this.getId(), labelId);
            return bl;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<Label> getLabels() {
        try (Statement statement = this.actions.statement();){
            PrimitiveIntIterator labels = statement.readOperations().nodeGetLabels(this.getId());
            List list = Iterators.asList((Iterator)PrimitiveIntCollections.map(labelId -> this.convertToLabel(statement, labelId), (PrimitiveIntIterator)labels));
            return list;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found", (Throwable)((Object)e));
        }
    }

    private Label convertToLabel(Statement statement, int labelId) {
        try {
            return Label.label((String)statement.readOperations().labelGetName(labelId));
        }
        catch (LabelNotFoundKernelException e) {
            throw new IllegalStateException("Label retrieved through kernel API should exist.", (Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDegree() {
        try (Statement statement = this.actions.statement();){
            int n = statement.readOperations().nodeGetDegree(this.nodeId, Direction.BOTH);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", (Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDegree(RelationshipType type) {
        try (Statement statement = this.actions.statement();){
            ReadOperations ops = statement.readOperations();
            int typeId = ops.relationshipTypeGetForName(type.name());
            if (typeId == -1) {
                int n = 0;
                return n;
            }
            int n = ops.nodeGetDegree(this.nodeId, Direction.BOTH, typeId);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", (Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDegree(Direction direction) {
        try (Statement statement = this.actions.statement();){
            ReadOperations ops = statement.readOperations();
            int n = ops.nodeGetDegree(this.nodeId, direction);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", (Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDegree(RelationshipType type, Direction direction) {
        try (Statement statement = this.actions.statement();){
            ReadOperations ops = statement.readOperations();
            int typeId = ops.relationshipTypeGetForName(type.name());
            if (typeId == -1) {
                int n = 0;
                return n;
            }
            int n = ops.nodeGetDegree(this.nodeId, direction, typeId);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", (Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<RelationshipType> getRelationshipTypes() {
        try (Statement statement = this.actions.statement();){
            PrimitiveIntIterator relTypes = statement.readOperations().nodeGetRelationshipTypes(this.nodeId);
            List list = Iterators.asList((Iterator)PrimitiveIntCollections.map(relTypeId -> this.convertToRelationshipType(statement, relTypeId), (PrimitiveIntIterator)relTypes));
            return list;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", (Throwable)((Object)e));
        }
    }

    private int[] relTypeIds(RelationshipType[] types, Statement statement) {
        int[] ids = new int[types.length];
        int outIndex = 0;
        for (RelationshipType type : types) {
            int id = statement.readOperations().relationshipTypeGetForName(type.name());
            if (id == -1) continue;
            ids[outIndex++] = id;
        }
        if (outIndex != ids.length) {
            ids = Arrays.copyOf(ids, outIndex);
        }
        return ids;
    }

    private RelationshipType convertToRelationshipType(Statement statement, int relTypeId) {
        try {
            return RelationshipType.withName((String)statement.readOperations().relationshipTypeGetName(relTypeId));
        }
        catch (RelationshipTypeIdNotFoundKernelException e) {
            throw new IllegalStateException("Kernel API returned non-existent relationship type: " + relTypeId);
        }
    }

    public static interface NodeActions {
        public Statement statement();

        public KernelTransaction kernelTransaction();

        public GraphDatabaseService getGraphDatabase();

        public void assertInUnterminatedTransaction();

        public void failTransaction();

        public Relationship newRelationshipProxy(long var1, long var3, int var5, long var6);
    }
}

