/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;

public class AnonymousContext
implements SecurityContext {
    private final AccessMode accessMode;

    private AnonymousContext(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public static AnonymousContext none() {
        return new AnonymousContext((AccessMode)AccessMode.Static.NONE);
    }

    public static AnonymousContext read() {
        return new AnonymousContext((AccessMode)AccessMode.Static.READ);
    }

    public static AnonymousContext write() {
        return new AnonymousContext((AccessMode)AccessMode.Static.WRITE);
    }

    public static AnonymousContext writeToken() {
        return new AnonymousContext((AccessMode)AccessMode.Static.TOKEN_WRITE);
    }

    public static AnonymousContext writeOnly() {
        return new AnonymousContext((AccessMode)AccessMode.Static.WRITE_ONLY);
    }

    public AuthSubject subject() {
        return AuthSubject.ANONYMOUS;
    }

    public boolean isAdmin() {
        return false;
    }

    public SecurityContext freeze() {
        return this;
    }

    public SecurityContext withMode(AccessMode mode) {
        return new SecurityContext.Frozen(this.subject(), mode);
    }

    public AccessMode mode() {
        return this.accessMode;
    }

    public String toString() {
        return this.defaultString("anonymous");
    }
}

