/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.nio.ByteBuffer;
import java.util.function.IntPredicate;
import org.neo4j.cursor.Cursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public interface StorageStatement
extends AutoCloseable {
    public void acquire();

    public void release();

    @Override
    public void close();

    public Cursor<NodeItem> acquireSingleNodeCursor(long var1);

    public Cursor<RelationshipItem> acquireSingleRelationshipCursor(long var1);

    public Cursor<RelationshipItem> acquireNodeRelationshipCursor(boolean var1, long var2, long var4, Direction var6, IntPredicate var7);

    public Cursor<RelationshipItem> relationshipsGetAllCursor();

    public Cursor<PropertyItem> acquirePropertyCursor(long var1, Lock var3, AssertOpen var4);

    public Cursor<PropertyItem> acquireSinglePropertyCursor(long var1, int var3, Lock var4, AssertOpen var5);

    public LabelScanReader getLabelScanReader();

    public IndexReader getIndexReader(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public IndexReader getFreshIndexReader(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public RecordCursors recordCursors();

    public long reserveNode();

    public long reserveRelationship();

    public Nodes nodes();

    public Relationships relationships();

    public Groups groups();

    public Properties properties();

    public static interface Properties
    extends RecordReads<PropertyRecord> {
        public PageCursor openStringPageCursor(long var1);

        public PageCursor openArrayPageCursor(long var1);

        public ByteBuffer loadString(long var1, ByteBuffer var3, PageCursor var4);

        public ByteBuffer loadArray(long var1, ByteBuffer var3, PageCursor var4);
    }

    public static interface Groups
    extends RecordReads<RelationshipGroupRecord> {
    }

    public static interface Relationships
    extends RecordReads<RelationshipRecord> {
    }

    public static interface Nodes
    extends RecordReads<NodeRecord> {
        public RecordCursor<DynamicRecord> newLabelCursor();
    }

    public static interface RecordReads<RECORD> {
        public PageCursor openPageCursor(long var1);

        public void loadRecordByCursor(long var1, RECORD var3, RecordLoad var4, PageCursor var5) throws InvalidRecordException;

        public long getHighestPossibleIdInUse();
    }
}

