/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.LogTailScannerMonitor;

public class LogTailScanner {
    static long NO_TRANSACTION_ID = -1L;
    private final LogFiles logFiles;
    private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader;
    private LogTailInformation logTailInformation;
    private final LogTailScannerMonitor monitor;
    private final boolean failOnCorruptedLogFiles;

    public LogTailScanner(LogFiles logFiles, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader, Monitors monitors) {
        this(logFiles, logEntryReader, monitors, false);
    }

    public LogTailScanner(LogFiles logFiles, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader, Monitors monitors, boolean failOnCorruptedLogFiles) {
        this.logFiles = logFiles;
        this.logEntryReader = logEntryReader;
        this.monitor = monitors.newMonitor(LogTailScannerMonitor.class, new String[0]);
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
    }

    private LogTailInformation findLogTail() throws IOException {
        long highestLogVersion;
        long version = highestLogVersion = this.logFiles.getHighestLogVersion();
        long versionToSearchForCommits = highestLogVersion;
        LogEntryStart latestStartEntry = null;
        long oldestStartEntryTransaction = -1L;
        long oldestVersionFound = -1L;
        LogEntryVersion latestLogEntryVersion = null;
        boolean startRecordAfterCheckpoint = false;
        boolean corruptedTransactionLogs = false;
        while (version >= this.logFiles.getLowestLogVersion() && version >= 0L) {
            oldestVersionFound = version;
            CheckPoint latestCheckPoint = null;
            try (PhysicalLogVersionedStoreChannel channel = this.logFiles.openForVersion(version);
                 LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, new ReadAheadLogChannel(channel));){
                while (cursor.next()) {
                    LogEntry entry = cursor.get();
                    if (entry instanceof CheckPoint) {
                        latestCheckPoint = (CheckPoint)entry.as();
                    } else if (entry instanceof LogEntryCommit) {
                        if (oldestStartEntryTransaction == NO_TRANSACTION_ID) {
                            oldestStartEntryTransaction = ((LogEntryCommit)entry).getTxId();
                        }
                    } else if (entry instanceof LogEntryStart) {
                        LogEntryStart startEntry = (LogEntryStart)entry.as();
                        if (version == versionToSearchForCommits) {
                            latestStartEntry = startEntry;
                        }
                        startRecordAfterCheckpoint = true;
                    }
                    if (version != versionToSearchForCommits && latestLogEntryVersion != null) continue;
                    latestLogEntryVersion = entry.getVersion();
                }
            }
            catch (Throwable t) {
                this.monitor.corruptedLogFile(version, t);
                if (this.failOnCorruptedLogFiles) {
                    throw Exceptions.launderedException((Throwable)t);
                }
                corruptedTransactionLogs = true;
            }
            if (latestCheckPoint != null) {
                return this.checkpointTailInformation(highestLogVersion, latestStartEntry, oldestVersionFound, latestLogEntryVersion, latestCheckPoint, corruptedTransactionLogs);
            }
            --version;
            if (latestStartEntry != null) continue;
            --versionToSearchForCommits;
        }
        return new LogTailInformation(corruptedTransactionLogs || startRecordAfterCheckpoint, oldestStartEntryTransaction, oldestVersionFound, highestLogVersion, latestLogEntryVersion);
    }

    protected LogTailInformation checkpointTailInformation(long highestLogVersion, LogEntryStart latestStartEntry, long oldestVersionFound, LogEntryVersion latestLogEntryVersion, CheckPoint latestCheckPoint, boolean corruptedTransactionLogs) throws IOException {
        LogPosition checkPointLogPosition = latestCheckPoint.getLogPosition();
        ExtractedTransactionRecord transactionRecord = this.extractFirstTxIdAfterPosition(checkPointLogPosition, highestLogVersion);
        long firstTxIdAfterPosition = transactionRecord.getId();
        boolean startRecordAfterCheckpoint = firstTxIdAfterPosition != NO_TRANSACTION_ID || latestStartEntry != null && latestStartEntry.getStartPosition().compareTo(latestCheckPoint.getLogPosition()) >= 0;
        boolean corruptedLogs = transactionRecord.isFailure() || corruptedTransactionLogs;
        return new LogTailInformation(latestCheckPoint, corruptedLogs || startRecordAfterCheckpoint, firstTxIdAfterPosition, oldestVersionFound, highestLogVersion, latestLogEntryVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExtractedTransactionRecord extractFirstTxIdAfterPosition(LogPosition initialPosition, long maxLogVersion) throws IOException {
        LogPosition currentPosition = initialPosition;
        while (currentPosition.getLogVersion() <= maxLogVersion) {
            PhysicalLogVersionedStoreChannel storeChannel = this.tryOpenStoreChannel(currentPosition);
            if (storeChannel != null) {
                Object object;
                try {
                    storeChannel.position(currentPosition.getByteOffset());
                    ReadAheadLogChannel logChannel = new ReadAheadLogChannel(storeChannel);
                    object = null;
                    try (LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, logChannel);){
                        while (true) {
                            if (cursor.next()) {
                                LogEntry entry = cursor.get();
                                if (!(entry instanceof LogEntryCommit)) continue;
                                ExtractedTransactionRecord extractedTransactionRecord = new ExtractedTransactionRecord(((LogEntryCommit)entry).getTxId());
                                return extractedTransactionRecord;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (logChannel != null) {
                            if (object != null) {
                                try {
                                    logChannel.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                logChannel.close();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    this.monitor.corruptedLogFile(currentPosition.getLogVersion(), t);
                    object = new ExtractedTransactionRecord(true);
                    return object;
                }
                finally {
                    storeChannel.close();
                }
            }
            currentPosition = LogPosition.start(currentPosition.getLogVersion() + 1L);
        }
        return new ExtractedTransactionRecord();
    }

    public LogTailInformation getTailInformation() throws UnderlyingStorageException {
        if (this.logTailInformation == null) {
            try {
                this.logTailInformation = this.findLogTail();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Error encountered while parsing transaction logs", e);
            }
        }
        return this.logTailInformation;
    }

    private PhysicalLogVersionedStoreChannel tryOpenStoreChannel(LogPosition currentPosition) {
        try {
            return this.logFiles.openForVersion(currentPosition.getLogVersion());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class LogTailInformation {
        public final CheckPoint lastCheckPoint;
        public final long firstTxIdAfterLastCheckPoint;
        public final long oldestLogVersionFound;
        public final long currentLogVersion;
        public final LogEntryVersion latestLogEntryVersion;
        private final boolean recordAfterCheckpoint;

        public LogTailInformation(boolean recordAfterCheckpoint, long firstTxIdAfterLastCheckPoint, long oldestLogVersionFound, long currentLogVersion, LogEntryVersion latestLogEntryVersion) {
            this(null, recordAfterCheckpoint, firstTxIdAfterLastCheckPoint, oldestLogVersionFound, currentLogVersion, latestLogEntryVersion);
        }

        LogTailInformation(CheckPoint lastCheckPoint, boolean recordAfterCheckpoint, long firstTxIdAfterLastCheckPoint, long oldestLogVersionFound, long currentLogVersion, LogEntryVersion latestLogEntryVersion) {
            this.lastCheckPoint = lastCheckPoint;
            this.firstTxIdAfterLastCheckPoint = firstTxIdAfterLastCheckPoint;
            this.oldestLogVersionFound = oldestLogVersionFound;
            this.currentLogVersion = currentLogVersion;
            this.latestLogEntryVersion = latestLogEntryVersion;
            this.recordAfterCheckpoint = recordAfterCheckpoint;
        }

        public boolean commitsAfterLastCheckpoint() {
            return this.recordAfterCheckpoint;
        }
    }

    static class ExtractedTransactionRecord {
        private final long id;
        private final boolean failure;

        ExtractedTransactionRecord() {
            this(NO_TRANSACTION_ID, false);
        }

        ExtractedTransactionRecord(long txId) {
            this(txId, false);
        }

        ExtractedTransactionRecord(boolean failure) {
            this(NO_TRANSACTION_ID, failure);
        }

        private ExtractedTransactionRecord(long txId, boolean failure) {
            this.id = txId;
            this.failure = failure;
        }

        public long getId() {
            return this.id;
        }

        public boolean isFailure() {
            return this.failure;
        }
    }
}

