/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LogPruningImpl
implements LogPruning {
    private final Lock pruneLock = new ReentrantLock();
    private final LogPruneStrategy pruneStrategy;
    private final Log msgLog;
    private final LogPruneStrategy.Monitor monitor;

    public LogPruningImpl(LogPruneStrategy pruneStrategy, LogProvider logProvider) {
        this.pruneStrategy = pruneStrategy;
        this.msgLog = logProvider.getLog(this.getClass());
        this.monitor = new LogPruneStrategy.Monitor(){

            @Override
            public void logsPruned(long upToVersion, long fromVersion, long toVersion) {
                LogPruningImpl.this.msgLog.info("Pruned log versions " + fromVersion + "-" + toVersion + ", last checkpoint was made in version " + upToVersion);
            }

            @Override
            public void noLogsPruned(long upToVersion) {
                LogPruningImpl.this.msgLog.info("No log version pruned, last checkpoint was made in version " + upToVersion);
            }
        };
    }

    @Override
    public void pruneLogs(long upToVersion) {
        if (this.pruneLock.tryLock()) {
            try {
                this.pruneStrategy.prune(upToVersion, this.monitor);
            }
            finally {
                this.pruneLock.unlock();
            }
        }
    }
}

