/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class TransactionLogFiles
extends LifecycleAdapter
implements LogFiles {
    public static final String DEFAULT_NAME = "neostore.transaction.db";
    public static final FilenameFilter DEFAULT_FILENAME_FILTER = TransactionLogFilesHelper.DEFAULT_FILENAME_FILTER;
    private static final File[] EMPTY_FILES_ARRAY = new File[0];
    private final TransactionLogFilesContext logFilesContext;
    private final TransactionLogFileInformation logFileInformation;
    private final LogHeaderCache logHeaderCache;
    private final FileSystemAbstraction fileSystem;
    private final LogFileCreationMonitor monitor;
    private final TransactionLogFilesHelper fileHelper;
    private final TransactionLogFile logFile;
    private final File logsDirectory;

    TransactionLogFiles(File logsDirectory, String name, TransactionLogFilesContext context) {
        this.logFilesContext = context;
        this.logsDirectory = logsDirectory;
        this.fileHelper = new TransactionLogFilesHelper(logsDirectory, name);
        this.fileSystem = context.getFileSystem();
        this.monitor = context.getLogFileCreationMonitor();
        this.logHeaderCache = new LogHeaderCache(1000);
        this.logFileInformation = new TransactionLogFileInformation(this, this.logHeaderCache, context);
        this.logFile = new TransactionLogFile(this, context);
    }

    public void init() throws IOException {
        this.logFile.init();
    }

    public void start() throws IOException {
        this.logFile.start();
    }

    public void shutdown() throws IOException {
        this.logFile.shutdown();
    }

    @Override
    public long getLogVersion(File historyLogFile) {
        return this.getLogVersion(historyLogFile.getName());
    }

    @Override
    public long getLogVersion(String historyLogFilename) {
        return this.fileHelper.getLogVersion(historyLogFilename);
    }

    @Override
    public File[] logFiles() {
        File[] files = this.fileSystem.listFiles(this.fileHelper.getParentDirectory(), this.fileHelper.getLogFilenameFilter());
        if (files == null) {
            return EMPTY_FILES_ARRAY;
        }
        return files;
    }

    @Override
    public boolean isLogFile(File file) {
        return this.fileHelper.getLogFilenameFilter().accept(null, file.getName());
    }

    @Override
    public File logFilesDirectory() {
        return this.logsDirectory;
    }

    @Override
    public File getLogFileForVersion(long version) {
        return this.fileHelper.getLogFileForVersion(version);
    }

    @Override
    public File getHighestLogFile() {
        return this.getLogFileForVersion(this.getHighestLogVersion());
    }

    @Override
    public boolean versionExists(long version) {
        return this.fileSystem.fileExists(this.getLogFileForVersion(version));
    }

    @Override
    public LogHeader extractHeader(long version) throws IOException {
        return LogHeaderReader.readLogHeader(this.fileSystem, this.getLogFileForVersion(version));
    }

    @Override
    public boolean hasAnyEntries(long version) {
        return this.fileSystem.getFileSize(this.getLogFileForVersion(version)) > 16L;
    }

    @Override
    public long getHighestLogVersion() {
        RangeLogVersionVisitor visitor = new RangeLogVersionVisitor();
        this.accept(visitor);
        return visitor.highest;
    }

    @Override
    public long getLowestLogVersion() {
        RangeLogVersionVisitor visitor = new RangeLogVersionVisitor();
        this.accept(visitor);
        return visitor.lowest;
    }

    @Override
    public void accept(LogVersionVisitor visitor) {
        for (File file : this.logFiles()) {
            visitor.visit(file, this.getLogVersion(file));
        }
    }

    @Override
    public PhysicalLogVersionedStoreChannel openForVersion(long version) throws IOException {
        File fileToOpen = this.getLogFileForVersion(version);
        if (!this.versionExists(version)) {
            throw new FileNotFoundException(String.format("File does not exist [%s]", fileToOpen.getCanonicalPath()));
        }
        StoreChannel rawChannel = null;
        try {
            rawChannel = this.openLogFileChannel(fileToOpen, OpenMode.READ);
            ByteBuffer buffer = ByteBuffer.allocate(16);
            LogHeader header = LogHeaderReader.readLogHeader(buffer, (ReadableByteChannel)rawChannel, true, fileToOpen);
            if (header == null || header.logVersion != version) {
                throw new IllegalStateException(String.format("Unexpected log file header. Expected header version: %d, actual header: %s", version, header != null ? header.toString() : "null header."));
            }
            return new PhysicalLogVersionedStoreChannel(rawChannel, version, header.logFormatVersion);
        }
        catch (FileNotFoundException cause) {
            throw (FileNotFoundException)Exceptions.withCause((Throwable)new FileNotFoundException(String.format("File could not be opened [%s]", fileToOpen.getCanonicalPath())), (Throwable)cause);
        }
        catch (Throwable unexpectedError) {
            if (rawChannel != null) {
                try {
                    rawChannel.close();
                }
                catch (IOException e) {
                    unexpectedError.addSuppressed(e);
                }
            }
            throw unexpectedError;
        }
    }

    PhysicalLogVersionedStoreChannel createLogChannelForVersion(long forVersion, OpenMode mode) throws IOException {
        File toOpen = this.getLogFileForVersion(forVersion);
        StoreChannel storeChannel = this.fileSystem.open(toOpen, mode);
        ByteBuffer headerBuffer = ByteBuffer.allocate(16);
        LogHeader header = LogHeaderReader.readLogHeader(headerBuffer, (ReadableByteChannel)storeChannel, false, toOpen);
        if (header == null) {
            long lastTxId = this.logFilesContext.getLastCommittedTransactionId();
            LogHeaderWriter.writeLogHeader(headerBuffer, forVersion, lastTxId);
            this.logHeaderCache.putHeader(forVersion, lastTxId);
            storeChannel.writeAll(headerBuffer);
            this.monitor.created(toOpen, forVersion, lastTxId);
        }
        byte formatVersion = header == null ? (byte)6 : (byte)header.logFormatVersion;
        return new PhysicalLogVersionedStoreChannel(storeChannel, forVersion, formatVersion);
    }

    @Override
    public void accept(LogHeaderVisitor visitor) throws IOException {
        long logVersion = this.getHighestLogVersion();
        long highTransactionId = this.logFilesContext.getLastCommittedTransactionId();
        while (this.versionExists(logVersion)) {
            LogHeader header;
            Long previousLogLastTxId = this.logHeaderCache.getLogHeader(logVersion);
            if (previousLogLastTxId == null && (header = LogHeaderReader.readLogHeader(this.fileSystem, this.getLogFileForVersion(logVersion), false)) != null) {
                assert (logVersion == header.logVersion);
                this.logHeaderCache.putHeader(header.logVersion, header.lastCommittedTxId);
                previousLogLastTxId = header.lastCommittedTxId;
            }
            if (previousLogLastTxId != null) {
                long lowTransactionId = previousLogLastTxId + 1L;
                LogPosition position = LogPosition.start(logVersion);
                if (!visitor.visit(position, lowTransactionId, highTransactionId)) break;
                highTransactionId = previousLogLastTxId;
            }
            --logVersion;
        }
    }

    @Override
    public LogFile getLogFile() {
        return this.logFile;
    }

    @Override
    public TransactionLogFileInformation getLogFileInformation() {
        return this.logFileInformation;
    }

    private StoreChannel openLogFileChannel(File file, OpenMode mode) throws IOException {
        return this.fileSystem.open(file, mode);
    }

    private static class RangeLogVersionVisitor
    implements LogVersionVisitor {
        private long lowest = -1L;
        private long highest = -1L;

        private RangeLogVersionVisitor() {
        }

        @Override
        public void visit(File file, long logVersion) {
            this.highest = Math.max(this.highest, logVersion);
            this.lowest = this.lowest == -1L ? logVersion : Math.min(this.lowest, logVersion);
        }
    }
}

