/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipCursor;

class RelationshipScanCursor
extends RelationshipCursor
implements org.neo4j.internal.kernel.api.RelationshipScanCursor {
    private int label;
    private long next;
    private long highMark;
    private PageCursor pageCursor;

    RelationshipScanCursor(Read read) {
        super(read);
    }

    void scan(int label) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = this.read.relationshipPage(0L);
        }
        this.next = 0L;
        this.label = label;
        this.highMark = this.read.relationshipHighMark();
    }

    void single(long reference) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = this.read.relationshipPage(reference);
        }
        this.next = reference;
        this.label = -1;
        this.highMark = -1L;
    }

    public boolean next() {
        do {
            if (this.next == -1L) {
                this.reset();
                return false;
            }
            do {
                this.read.relationship(this, this.next++, this.pageCursor);
                if (this.next <= this.highMark) continue;
                if (this.highMark == -1L) {
                    this.next = -1L;
                    return (this.label == -1 || this.label() == this.label) && this.inUse();
                }
                this.highMark = this.read.relationshipHighMark();
                if (this.next <= this.highMark) continue;
                this.next = -1L;
                return (this.label == -1 || this.label() == this.label) && this.inUse();
            } while (!this.inUse());
        } while (this.label != -1 && this.label() != this.label);
        return true;
    }

    public boolean shouldRetry() {
        return false;
    }

    public void close() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
        this.reset();
    }

    private void reset() {
        this.next = -1L;
        this.setId(-1L);
    }
}

