/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

class References {
    private static final long FLAG_MARKER = Long.MIN_VALUE;
    private static final long FLAGS = -1152921504606846976L;
    private static final long FILTER_FLAG = 0x2000000000000000L;
    private static final long GROUP_FLAG = 0x4000000000000000L;
    private static final long DIRECT_FLAG = 0x2000000000000000L;

    References() {
    }

    static long clearFlags(long reference) {
        assert (reference != -1L);
        return reference & 0xFFFFFFFFFFFFFFFL;
    }

    static long setGroupFlag(long relationshipReference) {
        return relationshipReference | 0x4000000000000000L | Long.MIN_VALUE;
    }

    static boolean hasGroupFlag(long relationshipReference) {
        assert (relationshipReference != -1L);
        return (relationshipReference & 0x4000000000000000L) != 0L;
    }

    static long setFilterFlag(long relationshipReference) {
        return relationshipReference | 0x2000000000000000L | Long.MIN_VALUE;
    }

    static boolean hasFilterFlag(long relationshipReference) {
        assert (relationshipReference != -1L);
        return (relationshipReference & 0x2000000000000000L) != 0L;
    }

    static long setDirectFlag(long groupReference) {
        return groupReference | 0x2000000000000000L | Long.MIN_VALUE;
    }

    static boolean hasDirectFlag(long groupReference) {
        assert (groupReference != -1L);
        return (groupReference & 0x2000000000000000L) != 0L;
    }
}

