/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.impl.coreapi.IndexProvider;
import org.neo4j.kernel.impl.coreapi.ReadOnlyIndexFacade;
import org.neo4j.kernel.impl.coreapi.RelationshipReadOnlyIndexFacade;

public class IndexManagerImpl
implements IndexManager {
    private final Supplier<Statement> transactionBridge;
    private final IndexProvider provider;
    private final AutoIndexer<Node> nodeAutoIndexer;
    private final RelationshipAutoIndexer relAutoIndexer;

    public IndexManagerImpl(Supplier<Statement> bridge, IndexProvider provider, AutoIndexer<Node> nodeAutoIndexer, RelationshipAutoIndexer relAutoIndexer) {
        this.transactionBridge = bridge;
        this.provider = provider;
        this.nodeAutoIndexer = nodeAutoIndexer;
        this.relAutoIndexer = relAutoIndexer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsForNodes(String indexName) {
        try (Statement statement = this.transactionBridge.get();){
            statement.readOperations().nodeExplicitIndexGetConfiguration(indexName);
            boolean bl = true;
            return bl;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            return false;
        }
    }

    public Index<Node> forNodes(String indexName) {
        return this.forNodes(indexName, null);
    }

    public Index<Node> forNodes(String indexName, Map<String, String> customConfiguration) {
        Index<Node> toReturn = this.provider.getOrCreateNodeIndex(indexName, customConfiguration);
        if ("node_auto_index".equals(indexName)) {
            return new ReadOnlyIndexFacade<Node>((ReadableIndex<Node>)toReturn);
        }
        return toReturn;
    }

    public String[] nodeIndexNames() {
        try (Statement statement = this.transactionBridge.get();){
            String[] stringArray = statement.readOperations().nodeExplicitIndexesGetAll();
            return stringArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsForRelationships(String indexName) {
        try (Statement statement = this.transactionBridge.get();){
            statement.readOperations().relationshipExplicitIndexGetConfiguration(indexName);
            boolean bl = true;
            return bl;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            return false;
        }
    }

    public RelationshipIndex forRelationships(String indexName) {
        return this.forRelationships(indexName, null);
    }

    public RelationshipIndex forRelationships(String indexName, Map<String, String> customConfiguration) {
        RelationshipIndex toReturn = this.provider.getOrCreateRelationshipIndex(indexName, customConfiguration);
        if ("relationship_auto_index".equals(indexName)) {
            return new RelationshipReadOnlyIndexFacade((ReadableRelationshipIndex)toReturn);
        }
        return toReturn;
    }

    public String[] relationshipIndexNames() {
        try (Statement statement = this.transactionBridge.get();){
            String[] stringArray = statement.readOperations().relationshipExplicitIndexesGetAll();
            return stringArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
        try (Statement statement = this.transactionBridge.get();){
            if (index.getEntityType().equals(Node.class)) {
                Map<String, String> map = statement.readOperations().nodeExplicitIndexGetConfiguration(index.getName());
                return map;
            }
            if (index.getEntityType().equals(Relationship.class)) {
                Map<String, String> map = statement.readOperations().relationshipExplicitIndexGetConfiguration(index.getName());
                return map;
            }
            throw new IllegalArgumentException("Unknown entity type " + index.getEntityType().getSimpleName());
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException("No node index '" + index.getName() + "' found");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String setConfiguration(Index<? extends PropertyContainer> index, String key, String value) {
        try (Statement statement = this.transactionBridge.get();){
            if (index.getEntityType().equals(Node.class)) {
                String string = statement.dataWriteOperations().nodeExplicitIndexSetConfiguration(index.getName(), key, value);
                return string;
            }
            if (index.getEntityType().equals(Relationship.class)) {
                String string = statement.dataWriteOperations().relationshipExplicitIndexSetConfiguration(index.getName(), key, value);
                return string;
            }
            throw new IllegalArgumentException("Unknown entity type " + index.getEntityType().getSimpleName());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String removeConfiguration(Index<? extends PropertyContainer> index, String key) {
        try (Statement statement = this.transactionBridge.get();){
            if (index.getEntityType().equals(Node.class)) {
                String string = statement.dataWriteOperations().nodeExplicitIndexRemoveConfiguration(index.getName(), key);
                return string;
            }
            if (index.getEntityType().equals(Relationship.class)) {
                String string = statement.dataWriteOperations().relationshipExplicitIndexRemoveConfiguration(index.getName(), key);
                return string;
            }
            throw new IllegalArgumentException("Unknown entity type " + index.getEntityType().getSimpleName());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Throwable)((Object)e));
        }
    }

    public AutoIndexer<Node> getNodeAutoIndexer() {
        return this.nodeAutoIndexer;
    }

    public RelationshipAutoIndexer getRelationshipAutoIndexer() {
        return this.relAutoIndexer;
    }
}

