/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Supplier;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ExplicitIndexHits;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.explicitindex.AbstractIndexHits;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class ExplicitIndexProxy<T extends PropertyContainer>
implements Index<T> {
    protected final String name;
    protected final Type type;
    protected final Supplier<Statement> statementContextBridge;
    private final GraphDatabaseService gds;

    public ExplicitIndexProxy(String name, Type type, GraphDatabaseService gds, Supplier<Statement> statementContextBridge) {
        this.name = name;
        this.type = type;
        this.gds = gds;
        this.statementContextBridge = statementContextBridge;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getEntityType() {
        return this.type.getEntityType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<T> get(String key, Object value) {
        try (Statement statement = this.statementContextBridge.get();){
            IndexHits<T> indexHits = this.wrapIndexHits(this.internalGet(key, value, statement));
            return indexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    private ExplicitIndexHits internalGet(String key, Object value, Statement statement) throws ExplicitIndexNotFoundKernelException {
        return this.type.get(statement.readOperations(), this.name, key, value);
    }

    protected IndexHits<T> wrapIndexHits(ExplicitIndexHits ids) {
        return new ExplicitIndexWrapHits(ids);
    }

    private T entityOf(long id) {
        return this.type.entity(id, this.gds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<T> query(String key, Object queryOrQueryObject) {
        try (Statement statement = this.statementContextBridge.get();){
            IndexHits<T> indexHits = this.wrapIndexHits(this.type.query(statement.readOperations(), this.name, key, queryOrQueryObject));
            return indexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<T> query(Object queryOrQueryObject) {
        try (Statement statement = this.statementContextBridge.get();){
            IndexHits<T> indexHits = this.wrapIndexHits(this.type.query(statement.readOperations(), this.name, queryOrQueryObject));
            return indexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    public boolean isWriteable() {
        return true;
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.gds;
    }

    public void add(T entity, String key, Object value) {
        try (Statement statement = this.statementContextBridge.get();){
            this.internalAdd(entity, key, value, statement);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(String.format("%s %d not found", new Object[]{this.type, this.type.id((PropertyContainer)entity)}), (Throwable)((Object)e));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    public void remove(T entity, String key, Object value) {
        try (Statement statement = this.statementContextBridge.get();){
            this.type.remove(statement.dataWriteOperations(), this.name, this.type.id((PropertyContainer)entity), key, value);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(entity + " doesn't exist");
        }
    }

    public void remove(T entity, String key) {
        try (Statement statement = this.statementContextBridge.get();){
            this.type.remove(statement.dataWriteOperations(), this.name, this.type.id((PropertyContainer)entity), key);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(entity + " doesn't exist");
        }
    }

    public void remove(T entity) {
        try (Statement statement = this.statementContextBridge.get();){
            this.internalRemove(statement, this.type.id((PropertyContainer)entity));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(entity + " doesn't exist");
        }
    }

    private void internalRemove(Statement statement, long id) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.type.remove(statement.dataWriteOperations(), this.name, id);
    }

    public void delete() {
        try (Statement statement = this.statementContextBridge.get();){
            this.type.drop(statement.dataWriteOperations(), this.name);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T putIfAbsent(T entity, String key, Object value) {
        try (Statement statement = this.statementContextBridge.get();){
            long existing = PrimitiveLongCollections.single((PrimitiveLongIterator)this.internalGet(key, value, statement), (long)-1L);
            if (existing != -1L) {
                T t = this.entityOf(existing);
                return t;
            }
            statement.readOperations().acquireExclusive(ResourceTypes.EXPLICIT_INDEX, ResourceTypes.explicitIndexResourceId(this.name, key));
            existing = PrimitiveLongCollections.single((PrimitiveLongIterator)this.internalGet(key, value, statement), (long)-1L);
            if (existing != -1L) {
                statement.readOperations().releaseExclusive(ResourceTypes.EXPLICIT_INDEX, ResourceTypes.explicitIndexResourceId(this.name, key));
                T t = this.entityOf(existing);
                return t;
            }
            this.internalAdd(entity, key, value, statement);
            T t = null;
            return t;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(String.format("%s %d not found", new Object[]{this.type, this.type.id((PropertyContainer)entity)}), (Throwable)((Object)e));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private void internalAdd(T entity, String key, Object value, Statement statement) throws EntityNotFoundException, InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
        this.type.add(statement.dataWriteOperations(), this.name, this.type.id((PropertyContainer)entity), key, value);
    }

    public String toString() {
        return "Index[" + (Object)((Object)this.type) + ", " + this.name + "]";
    }

    private class ExplicitIndexWrapHits
    extends AbstractIndexHits<T> {
        private final ExplicitIndexHits ids;
        private final KernelStatement statement;
        private volatile boolean closed;

        ExplicitIndexWrapHits(ExplicitIndexHits ids) {
            this.ids = ids;
            this.statement = (KernelStatement)ExplicitIndexProxy.this.statementContextBridge.get();
        }

        public int size() {
            return this.ids.size();
        }

        public float currentScore() {
            return this.ids.currentScore();
        }

        protected T fetchNextOrNull() {
            this.assertOpen();
            while (this.ids.hasNext()) {
                long id = this.ids.next();
                try {
                    return ExplicitIndexProxy.this.entityOf(id);
                }
                catch (NotFoundException e) {
                    try {
                        ExplicitIndexProxy.this.internalRemove(this.statement, id);
                    }
                    catch (EntityNotFoundException | InvalidTransactionTypeKernelException | ExplicitIndexNotFoundKernelException kernelException) {}
                }
            }
            this.close();
            return null;
        }

        private void assertOpen() {
            this.statement.assertOpen();
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.ids.close();
                this.statement.close();
            }
        }
    }

    public static interface Lookup {
        public GraphDatabaseService getGraphDatabaseService();
    }

    public static enum Type {
        NODE{

            Class<Node> getEntityType() {
                return Node.class;
            }

            Node entity(long id, GraphDatabaseService graphDatabaseService) {
                return graphDatabaseService.getNodeById(id);
            }

            @Override
            ExplicitIndexHits get(ReadOperations operations, String name, String key, Object value) throws ExplicitIndexNotFoundKernelException {
                return operations.nodeExplicitIndexGet(name, key, value);
            }

            @Override
            ExplicitIndexHits query(ReadOperations operations, String name, String key, Object queryOrQueryObject) throws ExplicitIndexNotFoundKernelException {
                return operations.nodeExplicitIndexQuery(name, key, queryOrQueryObject);
            }

            @Override
            ExplicitIndexHits query(ReadOperations operations, String name, Object queryOrQueryObject) throws ExplicitIndexNotFoundKernelException {
                return operations.nodeExplicitIndexQuery(name, queryOrQueryObject);
            }

            @Override
            void add(DataWriteOperations operations, String name, long id, String key, Object value) throws EntityNotFoundException, InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
                operations.nodeAddToExplicitIndex(name, id, key, value);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id, String key, Object value) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
                operations.nodeRemoveFromExplicitIndex(name, id, key, value);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id, String key) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
                operations.nodeRemoveFromExplicitIndex(name, id, key);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
                operations.nodeRemoveFromExplicitIndex(name, id);
            }

            @Override
            void drop(DataWriteOperations operations, String name) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
                operations.nodeExplicitIndexDrop(name);
            }

            @Override
            long id(PropertyContainer entity) {
                return ((Node)entity).getId();
            }
        }
        ,
        RELATIONSHIP{

            Class<Relationship> getEntityType() {
                return Relationship.class;
            }

            Relationship entity(long id, GraphDatabaseService graphDatabaseService) {
                return graphDatabaseService.getRelationshipById(id);
            }

            @Override
            ExplicitIndexHits get(ReadOperations operations, String name, String key, Object value) throws ExplicitIndexNotFoundKernelException {
                return operations.relationshipExplicitIndexGet(name, key, value, -1L, -1L);
            }

            @Override
            ExplicitIndexHits query(ReadOperations operations, String name, String key, Object queryOrQueryObject) throws ExplicitIndexNotFoundKernelException {
                return operations.relationshipExplicitIndexQuery(name, key, queryOrQueryObject, -1L, -1L);
            }

            @Override
            ExplicitIndexHits query(ReadOperations operations, String name, Object queryOrQueryObject) throws ExplicitIndexNotFoundKernelException {
                return operations.relationshipExplicitIndexQuery(name, queryOrQueryObject, -1L, -1L);
            }

            @Override
            void add(DataWriteOperations operations, String name, long id, String key, Object value) throws EntityNotFoundException, InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
                operations.relationshipAddToExplicitIndex(name, id, key, value);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id, String key, Object value) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException, EntityNotFoundException {
                operations.relationshipRemoveFromExplicitIndex(name, id, key, value);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id, String key) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException, EntityNotFoundException {
                operations.relationshipRemoveFromExplicitIndex(name, id, key);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException, EntityNotFoundException {
                operations.relationshipRemoveFromExplicitIndex(name, id);
            }

            @Override
            void drop(DataWriteOperations operations, String name) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException {
                operations.relationshipExplicitIndexDrop(name);
            }

            @Override
            long id(PropertyContainer entity) {
                return ((Relationship)entity).getId();
            }
        };


        abstract <T extends PropertyContainer> Class<T> getEntityType();

        abstract <T extends PropertyContainer> T entity(long var1, GraphDatabaseService var3);

        abstract ExplicitIndexHits get(ReadOperations var1, String var2, String var3, Object var4) throws ExplicitIndexNotFoundKernelException;

        abstract ExplicitIndexHits query(ReadOperations var1, String var2, String var3, Object var4) throws ExplicitIndexNotFoundKernelException;

        abstract ExplicitIndexHits query(ReadOperations var1, String var2, Object var3) throws ExplicitIndexNotFoundKernelException;

        abstract void add(DataWriteOperations var1, String var2, long var3, String var5, Object var6) throws EntityNotFoundException, InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException;

        abstract void remove(DataWriteOperations var1, String var2, long var3, String var5, Object var6) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException, EntityNotFoundException;

        abstract void remove(DataWriteOperations var1, String var2, long var3, String var5) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException, EntityNotFoundException;

        abstract void remove(DataWriteOperations var1, String var2, long var3) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException, EntityNotFoundException;

        abstract void drop(DataWriteOperations var1, String var2) throws InvalidTransactionTypeKernelException, ExplicitIndexNotFoundKernelException;

        abstract long id(PropertyContainer var1);
    }
}

