/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;

public class IndexPopulationFailedKernelException
extends KernelException {
    private static final String FORMAT_MESSAGE = "Failed to populate index for %s [labelId: %d, properties %s]";

    public IndexPopulationFailedKernelException(LabelSchemaDescriptor descriptor, String indexUserDescription, Throwable cause) {
        super((Status)Status.Schema.IndexCreationFailed, cause, FORMAT_MESSAGE, new Object[]{indexUserDescription, descriptor.getLabelId(), Arrays.toString(descriptor.getPropertyIds())});
    }

    public IndexPopulationFailedKernelException(LabelSchemaDescriptor descriptor, String indexUserDescription, String message) {
        super((Status)Status.Schema.IndexCreationFailed, "Failed to populate index for %s [labelId: %d, properties %s], due to " + message, new Object[]{indexUserDescription, descriptor.getLabelId(), Arrays.toString(descriptor.getPropertyIds())});
    }
}

