/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.HeaderException;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.DeserializerFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputGroupsDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputRelationshipValidator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class CsvInput
implements Input {
    private final Iterable<DataFactory<InputNode>> nodeDataFactory;
    private final Header.Factory nodeHeaderFactory;
    private final Iterable<DataFactory<InputRelationship>> relationshipDataFactory;
    private final Header.Factory relationshipHeaderFactory;
    private final IdType idType;
    private final Configuration config;
    private final Groups groups = new Groups();
    private final Collector badCollector;
    private final int maxProcessors;
    private final boolean validateRelationshipData;

    public CsvInput(Iterable<DataFactory<InputNode>> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory<InputRelationship>> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config, Collector badCollector, int maxProcessors, boolean validateRelationshipData) {
        this.maxProcessors = maxProcessors;
        CsvInput.assertSaneConfiguration(config);
        this.nodeDataFactory = nodeDataFactory;
        this.nodeHeaderFactory = nodeHeaderFactory;
        this.relationshipDataFactory = relationshipDataFactory;
        this.relationshipHeaderFactory = relationshipHeaderFactory;
        this.idType = idType;
        this.config = config;
        this.badCollector = badCollector;
        this.validateRelationshipData = validateRelationshipData;
        this.verifyHeaders();
    }

    private void verifyHeaders() {
        try {
            Throwable throwable;
            CharSeeker dataStream;
            for (DataFactory<InputNode> dataFactory : this.nodeDataFactory) {
                dataStream = CharSeekers.charSeeker((CharReadable)dataFactory.create(this.config).stream(), (org.neo4j.csv.reader.Configuration)this.config, (boolean)true);
                throwable = null;
                try {
                    Header header2 = this.nodeHeaderFactory.create(dataStream, this.config, this.idType);
                    Header.Entry idHeader = header2.entry(Type.ID);
                    if (idHeader == null) continue;
                    this.groups.getOrCreate(idHeader.groupName());
                }
                catch (Throwable header2) {
                    throwable = header2;
                    throw header2;
                }
                finally {
                    if (dataStream == null) continue;
                    if (throwable != null) {
                        try {
                            dataStream.close();
                        }
                        catch (Throwable header2) {
                            throwable.addSuppressed(header2);
                        }
                        continue;
                    }
                    dataStream.close();
                }
            }
            for (DataFactory<InputEntity> dataFactory : this.relationshipDataFactory) {
                dataStream = CharSeekers.charSeeker((CharReadable)dataFactory.create(this.config).stream(), (org.neo4j.csv.reader.Configuration)this.config, (boolean)true);
                throwable = null;
                try {
                    Header header = this.relationshipHeaderFactory.create(dataStream, this.config, this.idType);
                    this.verifyRelationshipHeader(header, Type.START_ID, dataStream.sourceDescription());
                    this.verifyRelationshipHeader(header, Type.END_ID, dataStream.sourceDescription());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataStream == null) continue;
                    if (throwable != null) {
                        try {
                            dataStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void verifyRelationshipHeader(Header header, Type type, String source) {
        Header.Entry entry = header.entry(type);
        String groupName = entry.groupName();
        if (this.groups.get(groupName) == null) {
            throw new HeaderException(String.format("Relationship header %s in %s refers to ID space %s which no node header specifies", header, source, groupName != null ? groupName : Group.GLOBAL.name()));
        }
    }

    private static void assertSaneConfiguration(Configuration config) {
        HashMap<Character, String> delimiters = new HashMap<Character, String>();
        delimiters.put(Character.valueOf(config.delimiter()), "delimiter");
        CsvInput.checkUniqueCharacter(delimiters, config.arrayDelimiter(), "array delimiter");
        CsvInput.checkUniqueCharacter(delimiters, config.quotationCharacter(), "quotation character");
    }

    private static void checkUniqueCharacter(Map<Character, String> characters, char character, String characterDescription) {
        String conflict = characters.put(Character.valueOf(character), characterDescription);
        if (conflict != null) {
            throw new IllegalArgumentException("Character '" + character + "' specified by " + characterDescription + " is the same as specified by " + conflict);
        }
    }

    @Override
    public InputIterable<InputNode> nodes() {
        return new InputIterable<InputNode>(){

            @Override
            public InputIterator<InputNode> iterator() {
                InputGroupsDeserializer.DeserializerFactory<InputNode> factory = DeserializerFactories.defaultNodeDeserializer(CsvInput.this.groups, CsvInput.this.config, CsvInput.this.idType, CsvInput.this.badCollector);
                return new InputGroupsDeserializer<InputNode>(CsvInput.this.nodeDataFactory.iterator(), CsvInput.this.nodeHeaderFactory, CsvInput.this.config, CsvInput.this.idType, CsvInput.this.maxProcessors, 1, factory, Validators.emptyValidator(), InputNode.class);
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public InputIterable<InputRelationship> relationships() {
        return new InputIterable<InputRelationship>(){

            @Override
            public InputIterator<InputRelationship> iterator() {
                InputGroupsDeserializer.DeserializerFactory<InputRelationship> factory = DeserializerFactories.defaultRelationshipDeserializer(CsvInput.this.groups, CsvInput.this.config, CsvInput.this.idType, CsvInput.this.badCollector);
                return new InputGroupsDeserializer<InputRelationship>(CsvInput.this.relationshipDataFactory.iterator(), CsvInput.this.relationshipHeaderFactory, CsvInput.this.config, CsvInput.this.idType, CsvInput.this.maxProcessors, 1, factory, CsvInput.this.validateRelationshipData ? new InputRelationshipValidator() : Validators.emptyValidator(), InputRelationship.class);
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
        return this.idType.idMapper(numberArrayFactory);
    }

    @Override
    public IdGenerator idGenerator() {
        return this.idType.idGenerator();
    }

    @Override
    public Collector badCollector() {
        return this.badCollector;
    }
}

