/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.Format;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.tracing.CheckPointTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageEngine;

public class CheckPointerImpl
extends LifecycleAdapter
implements CheckPointer {
    private final TransactionAppender appender;
    private final TransactionIdStore transactionIdStore;
    private final CheckPointThreshold threshold;
    private final StorageEngine storageEngine;
    private final LogPruning logPruning;
    private final DatabaseHealth databaseHealth;
    private final IOLimiter ioLimiter;
    private final Log msgLog;
    private final CheckPointTracer tracer;
    private final StoreCopyCheckPointMutex mutex;
    private long lastCheckPointedTx;

    public CheckPointerImpl(TransactionIdStore transactionIdStore, CheckPointThreshold threshold, StorageEngine storageEngine, LogPruning logPruning, TransactionAppender appender, DatabaseHealth databaseHealth, LogProvider logProvider, CheckPointTracer tracer, IOLimiter ioLimiter, StoreCopyCheckPointMutex mutex) {
        this.appender = appender;
        this.transactionIdStore = transactionIdStore;
        this.threshold = threshold;
        this.storageEngine = storageEngine;
        this.logPruning = logPruning;
        this.databaseHealth = databaseHealth;
        this.ioLimiter = ioLimiter;
        this.msgLog = logProvider.getLog(CheckPointerImpl.class);
        this.tracer = tracer;
        this.mutex = mutex;
    }

    public void start() throws Throwable {
        this.threshold.initialize(this.transactionIdStore.getLastClosedTransactionId());
    }

    /*
     * Loose catch block
     */
    @Override
    public long forceCheckPoint(TriggerInfo info) throws IOException {
        this.ioLimiter.disableLimit();
        try {
            try (Resource lock = this.mutex.checkPoint();){
                long l = this.doCheckPoint(info, LogCheckPointEvent.NULL);
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.ioLimiter.enableLimit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long tryCheckPoint(TriggerInfo info) throws IOException {
        this.ioLimiter.disableLimit();
        Resource lockAttempt = this.mutex.tryCheckPoint();
        if (lockAttempt != null) {
            try (Resource lock = lockAttempt;){
                long l = this.doCheckPoint(info, LogCheckPointEvent.NULL);
                return l;
            }
        }
        Resource lock = this.mutex.checkPoint();
        Throwable throwable = null;
        try {
            this.msgLog.info(info.describe(this.lastCheckPointedTx) + " Check pointing was already running, completed now");
            long l = this.lastCheckPointedTx;
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            this.ioLimiter.enableLimit();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long checkPointIfNeeded(TriggerInfo info) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long doCheckPoint(TriggerInfo triggerInfo, LogCheckPointEvent logCheckPointEvent) throws IOException {
        try {
            long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
            long lastClosedTransactionId = lastClosedTransaction[0];
            LogPosition logPosition = new LogPosition(lastClosedTransaction[1], lastClosedTransaction[2]);
            String prefix = triggerInfo.describe(lastClosedTransactionId);
            this.databaseHealth.assertHealthy(IOException.class);
            this.msgLog.info(prefix + " checkpoint started...");
            long startTime = System.currentTimeMillis();
            this.storageEngine.flushAndForce(this.ioLimiter);
            this.databaseHealth.assertHealthy(IOException.class);
            this.appender.checkPoint(logPosition, logCheckPointEvent);
            this.threshold.checkPointHappened(lastClosedTransactionId);
            this.msgLog.info(prefix + " checkpoint completed in " + Format.duration(System.currentTimeMillis() - startTime));
            this.logPruning.pruneLogs(logPosition.getLogVersion());
            this.lastCheckPointedTx = lastClosedTransactionId;
            return lastClosedTransactionId;
        }
        catch (Throwable t) {
            this.msgLog.error("Checkpoint failed", t);
            throw t;
        }
    }

    @Override
    public long lastCheckPointedTransactionId() {
        return this.lastCheckPointedTx;
    }
}

