/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.CountsMigrator;
import org.neo4j.kernel.impl.storemigration.participant.ExplicitIndexMigrator;
import org.neo4j.kernel.impl.storemigration.participant.NativeLabelScanStoreMigrator;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.logging.LogProvider;

public class DatabaseMigrator {
    private final MigrationProgressMonitor progressMonitor;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final LogService logService;
    private final SchemaIndexProviderMap schemaIndexProviderMap;
    private final Map<String, IndexImplementation> indexProviders;
    private final PageCache pageCache;
    private final RecordFormats format;
    private final LogTailScanner tailScanner;

    public DatabaseMigrator(MigrationProgressMonitor progressMonitor, FileSystemAbstraction fs, Config config, LogService logService, SchemaIndexProviderMap schemaIndexProviderMap, Map<String, IndexImplementation> indexProviders, PageCache pageCache, RecordFormats format, LogTailScanner tailScanner) {
        this.progressMonitor = progressMonitor;
        this.fs = fs;
        this.config = config;
        this.logService = logService;
        this.schemaIndexProviderMap = schemaIndexProviderMap;
        this.indexProviders = indexProviders;
        this.pageCache = pageCache;
        this.format = format;
        this.tailScanner = tailScanner;
    }

    public void migrate(File storeDir) {
        LogProvider logProvider = this.logService.getInternalLogProvider();
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.pageCache), this.format, this.tailScanner);
        StoreUpgrader storeUpgrader = new StoreUpgrader(upgradableDatabase, this.progressMonitor, this.config, this.fs, this.pageCache, logProvider);
        ExplicitIndexMigrator explicitIndexMigrator = new ExplicitIndexMigrator(this.fs, this.indexProviders, logProvider);
        StoreMigrator storeMigrator = new StoreMigrator(this.fs, this.pageCache, this.config, this.logService);
        NativeLabelScanStoreMigrator nativeLabelScanStoreMigrator = new NativeLabelScanStoreMigrator(this.fs, this.pageCache);
        CountsMigrator countsMigrator = new CountsMigrator(this.fs, this.pageCache, this.config);
        this.schemaIndexProviderMap.accept(provider -> storeUpgrader.addParticipant(provider.storeMigrationParticipant(this.fs, this.pageCache)));
        storeUpgrader.addParticipant(explicitIndexMigrator);
        storeUpgrader.addParticipant(storeMigrator);
        storeUpgrader.addParticipant(nativeLabelScanStoreMigrator);
        storeUpgrader.addParticipant(countsMigrator);
        storeUpgrader.migrateIfNeeded(storeDir);
    }
}

