/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdContainer;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;

public class IdGeneratorImpl
implements IdGenerator {
    public static final long INTEGER_MINUS_ONE = 0xFFFFFFFFL;
    private final long max;
    private final IdContainer idContainer;
    private long highId;
    private final IdType idType;

    public IdGeneratorImpl(FileSystemAbstraction fs, File file, int grabSize, long max, boolean aggressiveReuse, IdType idType, Supplier<Long> highId) {
        this.max = max;
        this.idType = idType;
        this.idContainer = new IdContainer(fs, file, grabSize, aggressiveReuse);
        this.highId = this.idContainer.init() ? this.idContainer.getInitialHighId() : highId.get().longValue();
    }

    @Override
    public synchronized long nextId() {
        this.assertStillOpen();
        long nextDefragId = this.idContainer.getReusableId();
        if (nextDefragId != -1L) {
            return nextDefragId;
        }
        if (IdValidator.isReservedId(this.highId)) {
            ++this.highId;
        }
        IdValidator.assertValidId(this.idType, this.highId, this.max);
        return this.highId++;
    }

    @Override
    public synchronized IdRange nextIdBatch(int size) {
        long id;
        this.assertStillOpen();
        int count = 0;
        long[] defragIds = new long[size];
        while (count < size && (id = this.idContainer.getReusableId()) != -1L) {
            defragIds[count++] = id;
        }
        long[] tmpArray = defragIds;
        defragIds = new long[count];
        System.arraycopy(tmpArray, 0, defragIds, 0, count);
        int sizeLeftForRange = size - count;
        long start = this.highId;
        this.setHighId(start + (long)sizeLeftForRange);
        return new IdRange(defragIds, start, sizeLeftForRange);
    }

    @Override
    public synchronized void setHighId(long id) {
        IdValidator.assertIdWithinCapacity(this.idType, id, this.max);
        this.highId = id;
    }

    @Override
    public synchronized long getHighId() {
        return this.highId;
    }

    @Override
    public synchronized long getHighestPossibleIdInUse() {
        return this.highId - 1L;
    }

    @Override
    public synchronized void freeId(long id) {
        this.idContainer.assertStillOpen();
        if (IdValidator.isReservedId(id)) {
            return;
        }
        if (id < 0L || id >= this.highId) {
            throw new IllegalArgumentException("Illegal id[" + id + "], highId is " + this.highId);
        }
        this.idContainer.freeId(id);
    }

    @Override
    public synchronized void close() {
        this.idContainer.close(this.highId);
    }

    public static void createGenerator(FileSystemAbstraction fs, File fileName, long highId, boolean throwIfFileExists) {
        IdContainer.createEmptyIdFile(fs, fileName, highId, throwIfFileExists);
    }

    public static long readHighId(FileSystemAbstraction fileSystem, File file) throws IOException {
        return IdContainer.readHighId(fileSystem, file);
    }

    @Override
    public synchronized long getNumberOfIdsInUse() {
        return this.highId - this.getDefragCount();
    }

    @Override
    public synchronized long getDefragCount() {
        return this.idContainer.getFreeIdCount();
    }

    @Override
    public synchronized void delete() {
        this.idContainer.delete();
    }

    private void assertStillOpen() {
        this.idContainer.assertStillOpen();
    }

    public String toString() {
        return "IdGeneratorImpl " + this.hashCode() + " [max=" + this.max + ", idContainer=" + this.idContainer + "]";
    }
}

