/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaCache {
    private final Lock cacheUpdateLock = new StampedLock().asWriteLock();
    private volatile SchemaCacheState schemaCacheState;

    public SchemaCache(ConstraintSemantics constraintSemantics, Iterable<SchemaRule> initialRules) {
        this.schemaCacheState = new SchemaCacheState(constraintSemantics, initialRules);
    }

    public Iterable<IndexRule> indexRules() {
        return this.schemaCacheState.indexRules();
    }

    public Iterable<ConstraintRule> constraintRules() {
        return this.schemaCacheState.constraintRules();
    }

    public boolean hasConstraintRule(ConstraintDescriptor descriptor) {
        return this.schemaCacheState.hasConstraintRule(descriptor);
    }

    public boolean hasIndexRule(SchemaDescriptor descriptor) {
        return this.schemaCacheState.hasIndexRule(descriptor);
    }

    public Iterator<ConstraintDescriptor> constraints() {
        return this.schemaCacheState.constraints();
    }

    public Iterator<ConstraintDescriptor> constraintsForLabel(int label) {
        return Iterators.filter(SchemaDescriptorPredicates.hasLabel(label), this.constraints());
    }

    public Iterator<ConstraintDescriptor> constraintsForRelationshipType(int relTypeId) {
        return Iterators.filter(SchemaDescriptorPredicates.hasRelType(relTypeId), this.constraints());
    }

    public Iterator<ConstraintDescriptor> constraintsForSchema(SchemaDescriptor descriptor) {
        return Iterators.filter(SchemaDescriptor.equalTo(descriptor), this.constraints());
    }

    public <P, T> T getOrCreateDependantState(Class<T> type, Function<P, T> factory, P parameter) {
        return this.schemaCacheState.getOrCreateDependantState(type, factory, parameter);
    }

    public void load(Iterable<SchemaRule> rules) {
        this.cacheUpdateLock.lock();
        try {
            ConstraintSemantics constraintSemantics = this.schemaCacheState.constraintSemantics;
            this.schemaCacheState = new SchemaCacheState(constraintSemantics, rules);
        }
        finally {
            this.cacheUpdateLock.unlock();
        }
    }

    public void addSchemaRule(SchemaRule rule) {
        this.cacheUpdateLock.lock();
        try {
            SchemaCacheState updatedSchemaState = new SchemaCacheState(this.schemaCacheState);
            updatedSchemaState.addSchemaRule(rule);
            this.schemaCacheState = updatedSchemaState;
        }
        finally {
            this.cacheUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaRule(long id) {
        this.cacheUpdateLock.lock();
        try {
            SchemaCacheState updatedSchemaState = new SchemaCacheState(this.schemaCacheState);
            updatedSchemaState.removeSchemaRule(id);
            this.schemaCacheState = updatedSchemaState;
        }
        finally {
            this.cacheUpdateLock.unlock();
        }
    }

    public IndexDescriptor indexDescriptor(LabelSchemaDescriptor descriptor) {
        return this.schemaCacheState.indexDescriptor(descriptor);
    }

    public Iterator<IndexDescriptor> indexDescriptorsForLabel(int labelId) {
        return this.schemaCacheState.indexDescriptorsForLabel(labelId);
    }

    public Iterator<IndexDescriptor> indexesByProperty(int propertyId) {
        return this.schemaCacheState.indexesByProperty(propertyId);
    }

    private static class SchemaCacheState {
        private final ConstraintSemantics constraintSemantics;
        private final Set<ConstraintDescriptor> constraints;
        private final Map<Long, IndexRule> indexRuleById;
        private final Map<Long, ConstraintRule> constraintRuleById;
        private final Map<SchemaDescriptor, IndexDescriptor> indexDescriptors;
        private final Map<Integer, Set<IndexDescriptor>> indexDescriptorsByLabel;
        private final Map<Class<?>, Object> dependantState;
        private final Map<Integer, List<IndexDescriptor>> indexByProperty;

        SchemaCacheState(ConstraintSemantics constraintSemantics, Iterable<SchemaRule> rules) {
            this.constraintSemantics = constraintSemantics;
            this.constraints = new HashSet<ConstraintDescriptor>();
            this.indexRuleById = new HashMap<Long, IndexRule>();
            this.constraintRuleById = new HashMap<Long, ConstraintRule>();
            this.indexDescriptors = new HashMap<SchemaDescriptor, IndexDescriptor>();
            this.indexDescriptorsByLabel = new HashMap<Integer, Set<IndexDescriptor>>();
            this.dependantState = new HashMap();
            this.indexByProperty = new HashMap<Integer, List<IndexDescriptor>>();
            this.load(rules);
        }

        SchemaCacheState(SchemaCacheState schemaCacheState) {
            this.constraintSemantics = schemaCacheState.constraintSemantics;
            this.indexRuleById = new HashMap<Long, IndexRule>(schemaCacheState.indexRuleById);
            this.constraintRuleById = new HashMap<Long, ConstraintRule>(schemaCacheState.constraintRuleById);
            this.constraints = new HashSet<ConstraintDescriptor>(schemaCacheState.constraints);
            this.indexDescriptors = new HashMap<SchemaDescriptor, IndexDescriptor>(schemaCacheState.indexDescriptors);
            this.indexDescriptorsByLabel = new HashMap<Integer, Set<IndexDescriptor>>(schemaCacheState.indexDescriptorsByLabel);
            this.dependantState = new HashMap();
            this.indexByProperty = new HashMap<Integer, List<IndexDescriptor>>(schemaCacheState.indexByProperty);
        }

        public void load(Iterable<SchemaRule> schemaRuleIterator) {
            for (SchemaRule schemaRule : schemaRuleIterator) {
                this.addSchemaRule(schemaRule);
            }
        }

        Iterable<IndexRule> indexRules() {
            return this.indexRuleById.values();
        }

        Iterable<ConstraintRule> constraintRules() {
            return this.constraintRuleById.values();
        }

        boolean hasConstraintRule(ConstraintDescriptor descriptor) {
            return this.constraints.contains(descriptor);
        }

        boolean hasIndexRule(SchemaDescriptor descriptor) {
            return this.indexDescriptors.containsKey(descriptor);
        }

        Iterator<ConstraintDescriptor> constraints() {
            return this.constraints.iterator();
        }

        IndexDescriptor indexDescriptor(LabelSchemaDescriptor descriptor) {
            return this.indexDescriptors.get(descriptor);
        }

        Iterator<IndexDescriptor> indexesByProperty(int propertyId) {
            List<IndexDescriptor> indexes = this.indexByProperty.get(propertyId);
            return indexes == null ? Collections.emptyIterator() : indexes.iterator();
        }

        Iterator<IndexDescriptor> indexDescriptorsForLabel(int labelId) {
            Set<IndexDescriptor> forLabel = this.indexDescriptorsByLabel.get(labelId);
            return forLabel == null ? Collections.emptyIterator() : forLabel.iterator();
        }

        <P, T> T getOrCreateDependantState(Class<T> type, Function<P, T> factory, P parameter) {
            return type.cast(this.dependantState.computeIfAbsent(type, key -> factory.apply(parameter)));
        }

        void addSchemaRule(SchemaRule rule) {
            if (rule instanceof ConstraintRule) {
                ConstraintRule constraintRule = (ConstraintRule)rule;
                this.constraintRuleById.put(constraintRule.getId(), constraintRule);
                this.constraints.add(this.constraintSemantics.readConstraint(constraintRule));
            } else if (rule instanceof IndexRule) {
                IndexRule indexRule = (IndexRule)rule;
                this.indexRuleById.put(indexRule.getId(), indexRule);
                LabelSchemaDescriptor schemaDescriptor = indexRule.schema();
                IndexDescriptor indexDescriptor = indexRule.getIndexDescriptor();
                this.indexDescriptors.put(schemaDescriptor, indexDescriptor);
                Set forLabel = this.indexDescriptorsByLabel.computeIfAbsent(schemaDescriptor.getLabelId(), k -> new HashSet());
                forLabel.add(indexDescriptor);
                for (int propertyId : indexRule.schema().getPropertyIds()) {
                    List indexesForProperty = this.indexByProperty.computeIfAbsent(propertyId, k -> new ArrayList());
                    indexesForProperty.add(indexDescriptor);
                }
            }
        }

        void removeSchemaRule(long id) {
            if (this.constraintRuleById.containsKey(id)) {
                ConstraintRule rule = this.constraintRuleById.remove(id);
                this.constraints.remove(rule.getConstraintDescriptor());
            } else if (this.indexRuleById.containsKey(id)) {
                IndexRule rule = this.indexRuleById.remove(id);
                LabelSchemaDescriptor schema = rule.schema();
                this.indexDescriptors.remove(schema);
                Set<IndexDescriptor> forLabel = this.indexDescriptorsByLabel.get(schema.getLabelId());
                forLabel.remove(rule.getIndexDescriptor());
                if (forLabel.isEmpty()) {
                    this.indexDescriptorsByLabel.remove(schema.getLabelId());
                }
                for (int propertyId : rule.schema().getPropertyIds()) {
                    List<IndexDescriptor> forProperty = this.indexByProperty.get(propertyId);
                    forProperty.remove(rule.getIndexDescriptor());
                    if (!forProperty.isEmpty()) continue;
                    this.indexByProperty.remove(propertyId);
                }
            }
        }
    }
}

