/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Comparator;
import java.util.stream.Stream;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.builtinprocs.ConfigResult;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BuiltInDbmsProcedures {
    @Context
    public GraphDatabaseAPI graph;
    @Context
    public SecurityContext securityContext;

    @Description(value="List the currently active config of Neo4j.")
    @Procedure(name="dbms.listConfig", mode=Mode.DBMS)
    public Stream<ConfigResult> listConfig(@Name(value="searchString", defaultValue="") String searchString) {
        this.securityContext.assertCredentialsNotExpired();
        if (!this.securityContext.isAdmin()) {
            throw new AuthorizationViolationException("Permission denied.");
        }
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        return config.getConfigValues().values().stream().filter(c -> !c.internal()).map(ConfigResult::new).filter(c -> c.name.toLowerCase().contains(searchString.toLowerCase())).sorted(Comparator.comparing(c -> c.name));
    }

    @Description(value="List all procedures in the DBMS.")
    @Procedure(name="dbms.procedures", mode=Mode.DBMS)
    public Stream<ProcedureResult> listProcedures() {
        this.securityContext.assertCredentialsNotExpired();
        return ((Procedures)((Object)this.graph.getDependencyResolver().resolveDependency(Procedures.class))).getAllProcedures().stream().sorted(Comparator.comparing(a -> a.name().toString())).map(x$0 -> new ProcedureResult((ProcedureSignature)x$0));
    }

    @Description(value="List all user functions in the DBMS.")
    @Procedure(name="dbms.functions", mode=Mode.DBMS)
    public Stream<FunctionResult> listFunctions() {
        this.securityContext.assertCredentialsNotExpired();
        return ((Procedures)((Object)this.graph.getDependencyResolver().resolveDependency(Procedures.class))).getAllFunctions().stream().sorted(Comparator.comparing(a -> a.name().toString())).map(x$0 -> new FunctionResult((UserFunctionSignature)x$0));
    }

    @Description(value="Clears all query caches.")
    @Procedure(name="dbms.clearQueryCaches", mode=Mode.DBMS)
    public Stream<StringResult> clearAllQueryCaches() {
        this.securityContext.assertCredentialsNotExpired();
        if (!this.securityContext.isAdmin()) {
            throw new AuthorizationViolationException("Permission denied.");
        }
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)this.graph.getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        long numberOfClearedQueries = queryExecutionEngine.clearQueryCaches() - 1L;
        String result = numberOfClearedQueries == 0L ? "Query cache already empty." : "Query caches successfully cleared of " + numberOfClearedQueries + " queries.";
        return Stream.of(new StringResult(result));
    }

    public class StringResult {
        public final String value;

        StringResult(String value) {
            this.value = value;
        }
    }

    public static class ProcedureResult {
        public final String name;
        public final String signature;
        public final String description;

        private ProcedureResult(ProcedureSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
        }
    }

    public static class FunctionResult {
        public final String name;
        public final String signature;
        public final String description;

        private FunctionResult(UserFunctionSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
        }
    }
}

