/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.values.storable.Value;

public class IndexEntryUpdate<INDEX_KEY extends LabelSchemaSupplier> {
    private final long entityId;
    private final UpdateMode updateMode;
    private final Value[] before;
    private final Value[] values;
    private final INDEX_KEY indexKey;

    private IndexEntryUpdate(long entityId, INDEX_KEY indexKey, UpdateMode updateMode, Value ... values) {
        this(entityId, indexKey, updateMode, (Value[])null, values);
    }

    private IndexEntryUpdate(long entityId, INDEX_KEY indexKey, UpdateMode updateMode, Value[] before, Value[] values) {
        assert (indexKey.schema().getPropertyIds().length == values.length) : String.format("IndexEntryUpdate values must be of same length as index compositness. Index on %s, but got values %s", indexKey.schema().toString(), Arrays.toString(values));
        assert (before == null || before.length == values.length);
        this.entityId = entityId;
        this.indexKey = indexKey;
        this.before = before;
        this.values = values;
        this.updateMode = updateMode;
    }

    public final long getEntityId() {
        return this.entityId;
    }

    public UpdateMode updateMode() {
        return this.updateMode;
    }

    public INDEX_KEY indexKey() {
        return this.indexKey;
    }

    public Value[] values() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntryUpdate that = (IndexEntryUpdate)o;
        if (this.entityId != that.entityId) {
            return false;
        }
        if (this.updateMode != that.updateMode) {
            return false;
        }
        if (!Arrays.equals(this.before, that.before)) {
            return false;
        }
        if (!Arrays.equals(this.values, that.values)) {
            return false;
        }
        return this.indexKey != null ? this.indexKey.schema().equals(that.indexKey.schema()) : that.indexKey == null;
    }

    public int hashCode() {
        int result = (int)(this.entityId ^ this.entityId >>> 32);
        result = 31 * result + (this.updateMode != null ? this.updateMode.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.before);
        result = 31 * result + Arrays.hashCode(this.values);
        result = 31 * result + (this.indexKey != null ? this.indexKey.schema().hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("IndexEntryUpdate[id=%d, mode=%s, %s, beforeValues=%s, values=%s]", new Object[]{this.entityId, this.updateMode, this.indexKey().schema().userDescription(SchemaUtil.idTokenNameLookup), Arrays.toString(this.before), Arrays.toString(this.values)});
    }

    public static <INDEX_KEY extends LabelSchemaSupplier> IndexEntryUpdate<INDEX_KEY> add(long nodeId, INDEX_KEY indexKey, Value ... values) {
        return new IndexEntryUpdate<INDEX_KEY>(nodeId, indexKey, UpdateMode.ADDED, values);
    }

    public static <INDEX_KEY extends LabelSchemaSupplier> IndexEntryUpdate<INDEX_KEY> remove(long nodeId, INDEX_KEY indexKey, Value ... values) {
        return new IndexEntryUpdate<INDEX_KEY>(nodeId, indexKey, UpdateMode.REMOVED, values);
    }

    public static <INDEX_KEY extends LabelSchemaSupplier> IndexEntryUpdate<INDEX_KEY> change(long nodeId, INDEX_KEY indexKey, Value before, Value after) {
        return new IndexEntryUpdate<INDEX_KEY>(nodeId, indexKey, UpdateMode.CHANGED, new Value[]{before}, new Value[]{after});
    }

    public static <INDEX_KEY extends LabelSchemaSupplier> IndexEntryUpdate<INDEX_KEY> change(long nodeId, INDEX_KEY indexKey, Value[] before, Value[] after) {
        return new IndexEntryUpdate<INDEX_KEY>(nodeId, indexKey, UpdateMode.CHANGED, before, after);
    }

    public Value[] beforeValues() {
        if (this.before == null) {
            throw new UnsupportedOperationException("beforeValues is only valid for `UpdateMode.CHANGED");
        }
        return this.before;
    }
}

