/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;

public class PathWrappingPathValue
extends PathValue {
    private final Path path;

    PathWrappingPathValue(Path path) {
        this.path = path;
    }

    public NodeValue startNode() {
        return ValueUtils.fromNodeProxy(this.path.startNode());
    }

    public NodeValue endNode() {
        return ValueUtils.fromNodeProxy(this.path.endNode());
    }

    public EdgeValue lastEdge() {
        return ValueUtils.fromRelationshipProxy(this.path.lastRelationship());
    }

    public NodeValue[] nodes() {
        int length = this.path.length() + 1;
        NodeValue[] values = new NodeValue[length];
        int i = 0;
        for (Node node : this.path.nodes()) {
            values[i++] = ValueUtils.fromNodeProxy(node);
        }
        return values;
    }

    public EdgeValue[] edges() {
        int length = this.path.length();
        EdgeValue[] values = new EdgeValue[length];
        int i = 0;
        for (Relationship relationship : this.path.relationships()) {
            values[i++] = ValueUtils.fromRelationshipProxy(relationship);
        }
        return values;
    }
}

