/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.storageengine.api.schema.IndexSample;

class FusionIndexPopulator
implements IndexPopulator {
    private final IndexPopulator nativePopulator;
    private final IndexPopulator lucenePopulator;
    private final FusionSchemaIndexProvider.Selector selector;
    private final long indexId;
    private final FusionSchemaIndexProvider.DropAction dropAction;

    FusionIndexPopulator(IndexPopulator nativePopulator, IndexPopulator lucenePopulator, FusionSchemaIndexProvider.Selector selector, long indexId, FusionSchemaIndexProvider.DropAction dropAction) {
        this.nativePopulator = nativePopulator;
        this.lucenePopulator = lucenePopulator;
        this.selector = selector;
        this.indexId = indexId;
        this.dropAction = dropAction;
    }

    @Override
    public void create() throws IOException {
        this.nativePopulator.create();
        this.lucenePopulator.create();
    }

    @Override
    public void drop() throws IOException {
        try {
            this.nativePopulator.drop();
        }
        finally {
            this.lucenePopulator.drop();
        }
        this.dropAction.drop(this.indexId);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        ArrayList luceneBatch = new ArrayList();
        ArrayList nativeBatch = new ArrayList();
        for (IndexEntryUpdate<?> update : updates) {
            ((Collection)this.selector.select(nativeBatch, luceneBatch, update.values())).add(update);
        }
        this.lucenePopulator.add(luceneBatch);
        this.nativePopulator.add(nativeBatch);
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        this.nativePopulator.verifyDeferredConstraints(propertyAccessor);
        this.lucenePopulator.verifyDeferredConstraints(propertyAccessor);
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new FusionIndexUpdater(this.nativePopulator.newPopulatingUpdater(accessor), this.lucenePopulator.newPopulatingUpdater(accessor), this.selector);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) throws IOException {
        try {
            this.nativePopulator.close(populationCompletedSuccessfully);
        }
        finally {
            this.lucenePopulator.close(populationCompletedSuccessfully);
        }
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        try {
            this.nativePopulator.markAsFailed(failure);
        }
        finally {
            this.lucenePopulator.markAsFailed(failure);
        }
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        this.selector.select(this.nativePopulator, this.lucenePopulator, update.values()).includeSample(update);
    }

    @Override
    public IndexSample sampleResult() {
        return FusionSchemaIndexProvider.combineSamples(this.nativePopulator.sampleResult(), this.lucenePopulator.sampleResult());
    }
}

