/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.upgrade.lucene.ExplicitIndexMigrationException;
import org.neo4j.upgrade.lucene.LuceneExplicitIndexUpgrader;

public class ExplicitIndexMigrator
extends AbstractStoreMigrationParticipant {
    private static final String LUCENE_EXPLICIT_INDEX_PROVIDER_NAME = "lucene";
    private final Map<String, IndexImplementation> indexProviders;
    private final FileSystemAbstraction fileSystem;
    private File migrationExplicitIndexesRoot;
    private File originalExplicitIndexesRoot;
    private final Log log;
    private boolean explicitIndexMigrated;

    public ExplicitIndexMigrator(FileSystemAbstraction fileSystem, Map<String, IndexImplementation> indexProviders, LogProvider logProvider) {
        super("Explicit indexes");
        this.fileSystem = fileSystem;
        this.indexProviders = indexProviders;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void migrate(File storeDir, File migrationDir, MigrationProgressMonitor.Section progressMonitor, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        IndexImplementation indexImplementation = this.indexProviders.get(LUCENE_EXPLICIT_INDEX_PROVIDER_NAME);
        if (indexImplementation != null) {
            RecordFormats to;
            RecordFormats from = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
            if (!from.hasSameCapabilities(to = RecordFormatSelector.selectForVersion(versionToMigrateTo), CapabilityType.INDEX)) {
                this.originalExplicitIndexesRoot = indexImplementation.getIndexImplementationDirectory(storeDir);
                this.migrationExplicitIndexesRoot = indexImplementation.getIndexImplementationDirectory(migrationDir);
                if (this.isNotEmptyDirectory(this.originalExplicitIndexesRoot)) {
                    this.migrateExplicitIndexes(progressMonitor);
                    this.explicitIndexMigrated = true;
                }
            }
        } else {
            this.log.debug("Lucene index provider not found, nothing to migrate.");
        }
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (this.explicitIndexMigrated) {
            this.fileSystem.deleteRecursively(this.originalExplicitIndexesRoot);
            this.fileSystem.moveToDirectory(this.migrationExplicitIndexesRoot, this.originalExplicitIndexesRoot.getParentFile());
        }
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
        if (this.isIndexMigrationDirectoryExists()) {
            this.fileSystem.deleteRecursively(this.migrationExplicitIndexesRoot);
        }
    }

    private boolean isIndexMigrationDirectoryExists() {
        return this.migrationExplicitIndexesRoot != null && this.fileSystem.fileExists(this.migrationExplicitIndexesRoot);
    }

    private void migrateExplicitIndexes(MigrationProgressMonitor.Section progressMonitor) throws IOException {
        try {
            this.fileSystem.copyRecursively(this.originalExplicitIndexesRoot, this.migrationExplicitIndexesRoot);
            Path indexRootPath = this.migrationExplicitIndexesRoot.toPath();
            LuceneExplicitIndexUpgrader indexUpgrader = this.createLuceneExplicitIndexUpgrader(indexRootPath, progressMonitor);
            indexUpgrader.upgradeIndexes();
        }
        catch (ExplicitIndexMigrationException lime) {
            this.log.error("Migration of explicit indexes failed. Index: " + lime.getFailedIndexName() + " can't be migrated.", (Throwable)lime);
            throw new IOException("Explicit index migration failed.", lime);
        }
    }

    private boolean isNotEmptyDirectory(File file) {
        if (this.fileSystem.isDirectory(file)) {
            File[] files = this.fileSystem.listFiles(file);
            return files != null && files.length > 0;
        }
        return false;
    }

    LuceneExplicitIndexUpgrader createLuceneExplicitIndexUpgrader(Path indexRootPath, MigrationProgressMonitor.Section progressMonitor) {
        return new LuceneExplicitIndexUpgrader(indexRootPath, this.progressMonitor(progressMonitor));
    }

    private LuceneExplicitIndexUpgrader.Monitor progressMonitor(final MigrationProgressMonitor.Section progressMonitor) {
        return new LuceneExplicitIndexUpgrader.Monitor(){

            public void starting(int total) {
                progressMonitor.start(total);
            }

            public void migrated(String name) {
                progressMonitor.progress(1L);
            }
        };
    }
}

