/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public abstract class AbstractDelegatingIndexProxy
implements IndexProxy {
    protected abstract IndexProxy getDelegate();

    @Override
    public void start() throws IOException {
        this.getDelegate().start();
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return this.getDelegate().newUpdater(mode);
    }

    @Override
    public Future<Void> drop() throws IOException {
        return this.getDelegate().drop();
    }

    @Override
    public InternalIndexState getState() {
        return this.getDelegate().getState();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.getDelegate().getDescriptor();
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this.getDelegate().schema();
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.getDelegate().getProviderDescriptor();
    }

    @Override
    public void force(IOLimiter ioLimiter) throws IOException {
        this.getDelegate().force(ioLimiter);
    }

    @Override
    public void refresh() throws IOException {
        this.getDelegate().refresh();
    }

    @Override
    public Future<Void> close() throws IOException {
        return this.getDelegate().close();
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        return this.getDelegate().newReader();
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        return this.getDelegate().awaitStoreScanCompleted();
    }

    @Override
    public void activate() throws IndexActivationFailedKernelException {
        this.getDelegate().activate();
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException, UniquePropertyValueValidationException {
        this.getDelegate().validate();
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        return this.getDelegate().getPopulationFailure();
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return this.getDelegate().getIndexPopulationProgress();
    }

    public String toString() {
        return String.format("%s -> %s", this.getClass().getSimpleName(), this.getDelegate().toString());
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        return this.getDelegate().snapshotFiles();
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        this.getDelegate().verifyDeferredConstraints(accessor);
    }
}

