/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

public class FreeIdKeeper
implements Closeable {
    private static final int ID_ENTRY_SIZE = 8;
    private final Deque<Long> freeIds = new ArrayDeque<Long>();
    private final Deque<Long> readFromDisk = new ArrayDeque<Long>();
    private final StoreChannel channel;
    private final int batchSize;
    private final boolean aggressiveMode;
    private long freeIdCount;
    private long stackPosition;
    private long initialPosition;

    FreeIdKeeper(StoreChannel channel, int batchSize, boolean aggressiveMode) throws IOException {
        this.channel = channel;
        this.batchSize = batchSize;
        this.aggressiveMode = aggressiveMode;
        this.stackPosition = this.initialPosition = channel.size();
        this.freeIdCount = this.stackPosition / 8L;
    }

    static long countFreeIds(StoreChannel channel) throws IOException {
        return channel.size() / 8L;
    }

    public void freeId(long id) {
        this.freeIds.add(id);
        ++this.freeIdCount;
        if (this.freeIds.size() >= this.batchSize) {
            long endPosition = this.flushFreeIds(ByteBuffer.allocate(this.batchSize * 8));
            if (this.aggressiveMode) {
                this.stackPosition = endPosition;
            }
        }
    }

    private void truncate(long position) {
        try {
            this.channel.truncate(position);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to truncate", e);
        }
    }

    public long getId() {
        long result;
        if (this.freeIds.size() > 0 && this.aggressiveMode) {
            result = this.freeIds.removeFirst();
            --this.freeIdCount;
        } else if (this.readFromDisk.size() > 0) {
            result = this.readFromDisk.removeFirst();
            --this.freeIdCount;
        } else if (this.freeIdCount > 0L && this.readIdBatch()) {
            result = this.readFromDisk.removeFirst();
            --this.freeIdCount;
        } else {
            result = -1L;
        }
        return result;
    }

    public long getCount() {
        return this.freeIdCount;
    }

    private boolean readIdBatch() {
        try {
            return this.readIdBatch0();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed reading free id batch", e);
        }
    }

    private boolean readIdBatch0() throws IOException {
        if (this.stackPosition == 0L) {
            return false;
        }
        long startPosition = Math.max(this.stackPosition - (long)(this.batchSize * 8), 0L);
        int bytesToRead = Math.toIntExact(this.stackPosition - startPosition);
        ByteBuffer readBuffer = ByteBuffer.allocate(bytesToRead);
        this.channel.position(startPosition);
        this.readAll(bytesToRead, readBuffer);
        this.stackPosition = startPosition;
        readBuffer.flip();
        int idsRead = bytesToRead / 8;
        for (int i = 0; i < idsRead; ++i) {
            long id = readBuffer.getLong();
            this.readFromDisk.add(id);
        }
        if (this.aggressiveMode) {
            this.truncate(startPosition);
        }
        return true;
    }

    private void readAll(int bytesToRead, ByteBuffer readBuffer) throws IOException {
        int bytesRead;
        int totalRead = 0;
        do {
            if ((bytesRead = this.channel.read(readBuffer)) > 0) continue;
            throw new IllegalStateException("Unexpected value returned: " + bytesRead);
        } while ((totalRead += bytesRead) < bytesToRead);
    }

    private long flushFreeIds(ByteBuffer writeBuffer) {
        try {
            return this.flushFreeIds0(writeBuffer);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to write free id batch", e);
        }
    }

    private long flushFreeIds0(ByteBuffer writeBuffer) throws IOException {
        this.channel.position(this.channel.size());
        writeBuffer.clear();
        while (!this.freeIds.isEmpty()) {
            long id = this.freeIds.removeFirst();
            if (id == -1L) continue;
            writeBuffer.putLong(id);
            if (writeBuffer.position() != writeBuffer.capacity()) continue;
            writeBuffer.flip();
            this.channel.writeAll(writeBuffer);
            writeBuffer.clear();
        }
        writeBuffer.flip();
        if (writeBuffer.hasRemaining()) {
            this.channel.writeAll(writeBuffer);
        }
        return this.channel.position();
    }

    @Override
    public void close() throws IOException {
        ByteBuffer writeBuffer = ByteBuffer.allocate(this.batchSize * 8);
        this.flushFreeIds(writeBuffer);
        this.freeIds.addAll(this.readFromDisk);
        this.flushFreeIds(writeBuffer);
        if (!this.aggressiveMode) {
            this.compact(writeBuffer);
        }
        this.channel.force(false);
    }

    private void compact(ByteBuffer writeBuffer) throws IOException {
        int nBytes;
        assert (this.stackPosition <= this.initialPosition);
        if (this.initialPosition == this.stackPosition) {
            return;
        }
        long writePosition = this.stackPosition;
        long readPosition = this.initialPosition;
        do {
            writeBuffer.clear();
            this.channel.position(readPosition);
            nBytes = this.channel.read(writeBuffer);
            if (nBytes <= 0) continue;
            readPosition += (long)nBytes;
            writeBuffer.flip();
            this.channel.position(writePosition);
            this.channel.writeAll(writeBuffer);
            writePosition += (long)nBytes;
        } while (nBytes > 0);
        this.channel.truncate(writePosition);
    }
}

