/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.builtinprocs.SpecialBuiltInProcedures;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ProcedureJarLoader;
import org.neo4j.kernel.impl.proc.ProcedureRegistry;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class Procedures
extends LifecycleAdapter {
    private final ProcedureRegistry registry = new ProcedureRegistry();
    private final TypeMappers typeMappers = new TypeMappers();
    private final ComponentRegistry safeComponents = new ComponentRegistry();
    private final ComponentRegistry allComponents = new ComponentRegistry();
    private final ReflectiveProcedureCompiler compiler;
    private final ThrowingConsumer<Procedures, ProcedureException> builtin;
    private final File pluginDir;
    private final Log log;

    public Procedures() {
        this(new SpecialBuiltInProcedures("N/A", "N/A"), null, (Log)NullLog.getInstance(), ProcedureConfig.DEFAULT);
    }

    public Procedures(ThrowingConsumer<Procedures, ProcedureException> builtin, File pluginDir, Log log, ProcedureConfig config) {
        this.builtin = builtin;
        this.pluginDir = pluginDir;
        this.log = log;
        this.compiler = new ReflectiveProcedureCompiler(this.typeMappers, this.safeComponents, this.allComponents, log, config);
    }

    public void register(CallableProcedure proc) throws ProcedureException {
        this.register(proc, false);
    }

    public void register(CallableUserFunction function) throws ProcedureException {
        this.register(function, false);
    }

    public void register(CallableUserAggregationFunction function) throws ProcedureException {
        this.register(function, false);
    }

    public void register(CallableUserFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        this.registry.register(function, overrideCurrentImplementation);
    }

    public void register(CallableUserAggregationFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        this.registry.register(function, overrideCurrentImplementation);
    }

    public void register(CallableProcedure proc, boolean overrideCurrentImplementation) throws ProcedureException {
        this.registry.register(proc, overrideCurrentImplementation);
    }

    public void registerProcedure(Class<?> proc) throws KernelException {
        this.registerProcedure(proc, false);
    }

    public void registerProcedure(Class<?> proc, boolean overrideCurrentImplementation) throws KernelException {
        this.registerProcedure(proc, overrideCurrentImplementation, Optional.empty());
    }

    public void registerProcedure(Class<?> proc, boolean overrideCurrentImplementation, Optional<String> warning) throws KernelException {
        for (CallableProcedure procedure : this.compiler.compileProcedure(proc, warning, true)) {
            this.register(procedure, overrideCurrentImplementation);
        }
    }

    public void registerFunction(Class<?> func) throws KernelException {
        this.registerFunction(func, false);
    }

    public void registerAggregationFunction(Class<?> func, boolean overrideCurrentImplementation) throws KernelException {
        for (CallableUserAggregationFunction function : this.compiler.compileAggregationFunction(func)) {
            this.register(function, overrideCurrentImplementation);
        }
    }

    public void registerAggregationFunction(Class<?> func) throws KernelException {
        this.registerAggregationFunction(func, false);
    }

    public void registerFunction(Class<?> func, boolean overrideCurrentImplementation) throws KernelException {
        for (CallableUserFunction function : this.compiler.compileFunction(func)) {
            this.register(function, overrideCurrentImplementation);
        }
    }

    public void registerType(Class<?> javaClass, TypeMappers.NeoValueConverter toNeo) {
        this.typeMappers.registerType(javaClass, toNeo);
    }

    public <T> void registerComponent(Class<T> cls, ComponentRegistry.Provider<T> provider, boolean safe) {
        if (safe) {
            this.safeComponents.register(cls, provider);
        }
        this.allComponents.register(cls, provider);
    }

    public ProcedureSignature procedure(QualifiedName name) throws ProcedureException {
        return this.registry.procedure(name);
    }

    public Optional<UserFunctionSignature> function(QualifiedName name) {
        return this.registry.function(name);
    }

    public Optional<UserFunctionSignature> aggregationFunction(QualifiedName name) {
        return this.registry.aggregationFunction(name);
    }

    public Set<ProcedureSignature> getAllProcedures() {
        return this.registry.getAllProcedures();
    }

    public Set<UserFunctionSignature> getAllFunctions() {
        return this.registry.getAllFunctions();
    }

    public RawIterator<Object[], ProcedureException> callProcedure(Context ctx, QualifiedName name, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
        return this.registry.callProcedure(ctx, name, input, resourceTracker);
    }

    public Object callFunction(Context ctx, QualifiedName name, Object[] input) throws ProcedureException {
        return this.registry.callFunction(ctx, name, input);
    }

    public CallableUserAggregationFunction.Aggregator createAggregationFunction(Context ctx, QualifiedName name) throws ProcedureException {
        return this.registry.createAggregationFunction(ctx, name);
    }

    public void start() throws Throwable {
        ProcedureJarLoader loader = new ProcedureJarLoader(this.compiler, this.log);
        ProcedureJarLoader.Callables callables = loader.loadProceduresFromDir(this.pluginDir);
        for (CallableProcedure callableProcedure : callables.procedures()) {
            this.register(callableProcedure);
        }
        for (CallableUserFunction callableUserFunction : callables.functions()) {
            this.register(callableUserFunction);
        }
        for (CallableUserAggregationFunction callableUserAggregationFunction : callables.aggregationFunctions()) {
            this.register(callableUserAggregationFunction);
        }
        this.builtin.accept((Object)this);
    }
}

