/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.Locks;

public final class LockClientStateHolder {
    private static final int FLAG_BITS = 1;
    private static final int CLIENT_BITS = 31;
    private static final int STATE_BIT_MASK = Integer.MIN_VALUE;
    private static final int STOPPED = Integer.MIN_VALUE;
    private static final int INITIAL_STATE = 0;
    private AtomicInteger clientState = new AtomicInteger(0);

    public boolean hasActiveClients() {
        return this.getActiveClients(this.clientState.get()) > 0;
    }

    public void stopClient() {
        int currentValue;
        while (!this.clientState.compareAndSet(currentValue = this.clientState.get(), this.stateWithNewStatus(currentValue, Integer.MIN_VALUE))) {
        }
    }

    public void incrementActiveClients(Locks.Client client) {
        int currentState;
        do {
            if (!this.isStopped(currentState = this.clientState.get())) continue;
            throw new LockClientStoppedException(client);
        } while (!this.clientState.compareAndSet(currentState, this.incrementActiveClients(currentState)));
    }

    public void decrementActiveClients() {
        int currentState;
        while (!this.clientState.compareAndSet(currentState = this.clientState.get(), this.decrementActiveClients(currentState))) {
        }
    }

    public boolean isStopped() {
        return this.isStopped(this.clientState.get());
    }

    public void reset() {
        this.clientState.set(0);
    }

    private boolean isStopped(int clientState) {
        return this.getStatus(clientState) == Integer.MIN_VALUE;
    }

    private int getStatus(int clientState) {
        return clientState & Integer.MIN_VALUE;
    }

    private int getActiveClients(int clientState) {
        return clientState & Integer.MAX_VALUE;
    }

    private int stateWithNewStatus(int clientState, int newStatus) {
        return newStatus | this.getActiveClients(clientState);
    }

    private int incrementActiveClients(int clientState) {
        return this.getStatus(clientState) | Math.incrementExact(this.getActiveClients(clientState));
    }

    private int decrementActiveClients(int clientState) {
        return this.getStatus(clientState) | Math.decrementExact(this.getActiveClients(clientState));
    }
}

