/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import org.neo4j.configuration.Description;
import org.neo4j.configuration.ReplacedBy;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Configuration options for HTTP connectors. \"(http-connector-key)\" is a placeholder for a unique name for the connector, for instance \"http-public\" or some other name that describes what the connector is for.")
public class HttpConnector
extends Connector {
    @Description(value="Enable TLS for this connector")
    public final Setting<Encryption> encryption;
    @Description(value="Address the connector should bind to. This setting is deprecated and will be replaced by `+listen_address+`")
    @Deprecated
    @ReplacedBy(value="dbms.connector.X.listen_address")
    public final Setting<ListenSocketAddress> address;
    @Description(value="Address the connector should bind to")
    public final Setting<ListenSocketAddress> listen_address;
    @Description(value="Advertised address for this connector")
    public final Setting<AdvertisedSocketAddress> advertised_address;
    private final Encryption encryptionLevel;

    public HttpConnector() {
        this("(http-connector-key)");
    }

    public HttpConnector(Encryption encryptionLevel) {
        this("(http-connector-key)", encryptionLevel);
    }

    public HttpConnector(String key) {
        this(key, Encryption.NONE);
    }

    public HttpConnector(String key, Encryption encryptionLevel) {
        super(key);
        this.encryptionLevel = encryptionLevel;
        this.encryption = this.group.scope(Settings.setting("encryption", Settings.options(Encryption.class), Settings.NO_DEFAULT));
        BaseSetting<ListenSocketAddress> legacyAddressSetting = Settings.listenAddress("address", encryptionLevel.defaultPort);
        Setting<ListenSocketAddress> listenAddressSetting = Settings.legacyFallback(legacyAddressSetting, Settings.listenAddress("listen_address", encryptionLevel.defaultPort));
        this.address = this.group.scope(legacyAddressSetting);
        this.listen_address = this.group.scope(listenAddressSetting);
        this.advertised_address = this.group.scope(Settings.advertisedAddress("advertised_address", listenAddressSetting));
    }

    public Encryption encryptionLevel() {
        return this.encryptionLevel;
    }

    public static enum Encryption {
        NONE("http", 7474),
        TLS("https", 7473);

        final String uriScheme;
        final int defaultPort;

        private Encryption(String uriScheme, int defaultPort) {
            this.uriScheme = uriScheme;
            this.defaultPort = defaultPort;
        }
    }
}

