/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.NumberHitIterator;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class NativeSchemaNumberIndexReader<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
implements IndexReader {
    private final GBPTree<KEY, VALUE> tree;
    private final Layout<KEY, VALUE> layout;
    private final Set<RawCursor<Hit<KEY, VALUE>, IOException>> openSeekers;

    NativeSchemaNumberIndexReader(GBPTree<KEY, VALUE> tree, Layout<KEY, VALUE> layout) {
        this.tree = tree;
        this.layout = layout;
        this.openSeekers = new HashSet<RawCursor<Hit<KEY, VALUE>, IOException>>();
    }

    public void close() {
        this.ensureOpenSeekersClosed();
    }

    @Override
    public IndexSampler createSampler() {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        FullScanNonUniqueIndexSampler<KEY, VALUE> sampler = new FullScanNonUniqueIndexSampler<KEY, VALUE>(this.tree, this.layout, indexSamplingConfig);
        return sampler::result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        SchemaNumberKey treeKeyFrom = (SchemaNumberKey)((Object)this.layout.newKey());
        SchemaNumberKey treeKeyTo = (SchemaNumberKey)((Object)this.layout.newKey());
        treeKeyFrom.from(nodeId, propertyValues);
        treeKeyTo.from(nodeId, propertyValues);
        try (RawCursor seeker = this.tree.seek((Object)treeKeyFrom, (Object)treeKeyTo);){
            long count = 0L;
            while (seeker.next()) {
                if (((SchemaNumberKey)((Object)((Hit)seeker.get()).key())).entityId != nodeId) continue;
                ++count;
            }
            long l = count;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public PrimitiveLongIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        SchemaNumberKey treeKeyFrom = (SchemaNumberKey)((Object)this.layout.newKey());
        SchemaNumberKey treeKeyTo = (SchemaNumberKey)((Object)this.layout.newKey());
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                treeKeyFrom.initAsLowest();
                treeKeyTo.initAsHighest();
                return this.startSeekForInitializedRange(treeKeyFrom, treeKeyTo);
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                treeKeyFrom.from(Long.MIN_VALUE, exactPredicate.value());
                treeKeyTo.from(Long.MAX_VALUE, exactPredicate.value());
                return this.startSeekForInitializedRange(treeKeyFrom, treeKeyTo);
            }
            case rangeNumeric: {
                IndexQuery.NumberRangePredicate rangePredicate = (IndexQuery.NumberRangePredicate)predicate;
                this.initFromForRange(rangePredicate, treeKeyFrom);
                this.initToForRange(rangePredicate, treeKeyTo);
                return this.startSeekForInitializedRange(treeKeyFrom, treeKeyTo);
            }
        }
        throw new IllegalArgumentException("IndexQuery of type " + (Object)((Object)predicate.type()) + " is not supported.");
    }

    private void initToForRange(IndexQuery.NumberRangePredicate rangePredicate, KEY treeKeyTo) {
        Value toValue = rangePredicate.toAsValue();
        if (toValue.valueGroup() == ValueGroup.NO_VALUE) {
            ((SchemaNumberKey)((Object)treeKeyTo)).initAsHighest();
        } else {
            ((SchemaNumberKey)((Object)treeKeyTo)).from(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE, toValue);
            ((SchemaNumberKey)((Object)treeKeyTo)).entityIdIsSpecialTieBreaker = true;
        }
    }

    private void initFromForRange(IndexQuery.NumberRangePredicate rangePredicate, KEY treeKeyFrom) {
        Value fromValue = rangePredicate.fromAsValue();
        if (fromValue.valueGroup() == ValueGroup.NO_VALUE) {
            ((SchemaNumberKey)((Object)treeKeyFrom)).initAsLowest();
        } else {
            ((SchemaNumberKey)((Object)treeKeyFrom)).from(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE, fromValue);
            ((SchemaNumberKey)((Object)treeKeyFrom)).entityIdIsSpecialTieBreaker = true;
        }
    }

    @Override
    public boolean hasFullNumberPrecision(IndexQuery ... predicates) {
        return true;
    }

    private PrimitiveLongIterator startSeekForInitializedRange(KEY treeKeyFrom, KEY treeKeyTo) {
        if (this.layout.compare(treeKeyFrom, treeKeyTo) > 0) {
            return PrimitiveLongCollections.emptyIterator();
        }
        try {
            RawCursor seeker = this.tree.seek(treeKeyFrom, treeKeyTo);
            this.openSeekers.add(seeker);
            return new NumberHitIterator<KEY, VALUE>(seeker, this.openSeekers);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void ensureOpenSeekersClosed() {
        try {
            IOUtils.closeAll(this.openSeekers);
            this.openSeekers.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

